/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id.validation;

import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.id.validation.IdCapacityExceededException;
import org.neo4j.kernel.impl.store.id.validation.NegativeIdException;
import org.neo4j.kernel.impl.store.id.validation.ReservedIdException;

public final class IdValidator {
    private IdValidator() {
    }

    public static boolean isReservedId(long id2) {
        return id2 == 0xFFFFFFFFL;
    }

    public static void assertValidId(IdType idType, long id2, long maxId) {
        if (IdValidator.isReservedId(id2)) {
            throw new ReservedIdException(id2);
        }
        IdValidator.assertIdWithinCapacity(idType, id2, maxId);
    }

    public static void assertIdWithinCapacity(IdType idType, long id2, long maxId) {
        if (id2 < 0L) {
            throw new NegativeIdException(id2);
        }
        if (id2 > maxId) {
            throw new IdCapacityExceededException(idType, id2, maxId);
        }
    }

    public static boolean hasReservedIdInRange(long startIdInclusive, long endIdExclusive) {
        return startIdInclusive <= 0xFFFFFFFFL && endIdExclusive > 0xFFFFFFFFL;
    }
}

