/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format;

import org.neo4j.helpers.ArrayUtil;
import org.neo4j.kernel.impl.store.format.CapabilityType;

public enum Capability {
    SCHEMA(CapabilityType.STORE),
    DENSE_NODES(CapabilityType.FORMAT, CapabilityType.STORE),
    RELATIONSHIP_TYPE_3BYTES(CapabilityType.FORMAT, CapabilityType.STORE),
    LUCENE_3(CapabilityType.INDEX),
    LUCENE_5(CapabilityType.INDEX),
    POINT_PROPERTIES(true, CapabilityType.STORE),
    TEMPORAL_PROPERTIES(true, CapabilityType.STORE),
    SECONDARY_RECORD_UNITS(CapabilityType.FORMAT);

    private final CapabilityType[] types;
    private boolean additive;

    private Capability(CapabilityType ... types2) {
        this(false, types2);
    }

    private Capability(boolean additive, CapabilityType ... types2) {
        this.additive = additive;
        this.types = types2;
    }

    public boolean isType(CapabilityType type) {
        return ArrayUtil.contains(this.types, type);
    }

    public boolean isAdditive() {
        return this.additive;
    }
}

