/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.ZonedDateTimeIndexKey;

class ZonedDateTimeLayout
extends IndexLayout<ZonedDateTimeIndexKey, NativeIndexValue> {
    static final int ZONE_ID_FLAG = 0x1000000;
    static final int ZONE_ID_MASK = 0xFFFFFF;
    static final int ZONE_ID_HIGH = 0x800000;
    static final int ZONE_ID_EXT = -16777216;

    ZonedDateTimeLayout() {
        super("Tdt", 0, 1);
    }

    public ZonedDateTimeIndexKey newKey() {
        return new ZonedDateTimeIndexKey();
    }

    public ZonedDateTimeIndexKey copyKey(ZonedDateTimeIndexKey key, ZonedDateTimeIndexKey into) {
        into.epochSecondUTC = key.epochSecondUTC;
        into.nanoOfSecond = key.nanoOfSecond;
        into.zoneId = key.zoneId;
        into.zoneOffsetSeconds = key.zoneOffsetSeconds;
        into.setEntityId(key.getEntityId());
        into.setCompareId(key.getCompareId());
        return into;
    }

    public int keySize(ZonedDateTimeIndexKey key) {
        return 24;
    }

    public void writeKey(PageCursor cursor, ZonedDateTimeIndexKey key) {
        cursor.putLong(key.epochSecondUTC);
        cursor.putInt(key.nanoOfSecond);
        if (key.zoneId >= 0) {
            cursor.putInt(key.zoneId | 0x1000000);
        } else {
            cursor.putInt(key.zoneOffsetSeconds & 0xFFFFFF);
        }
        cursor.putLong(key.getEntityId());
    }

    public void readKey(PageCursor cursor, ZonedDateTimeIndexKey into, int keySize) {
        into.epochSecondUTC = cursor.getLong();
        into.nanoOfSecond = cursor.getInt();
        int encodedZone = cursor.getInt();
        if (ZonedDateTimeLayout.isZoneId(encodedZone)) {
            into.zoneId = ZonedDateTimeLayout.asZoneId(encodedZone);
            into.zoneOffsetSeconds = 0;
        } else {
            into.zoneId = (short)-1;
            into.zoneOffsetSeconds = ZonedDateTimeLayout.asZoneOffset(encodedZone);
        }
        into.setEntityId(cursor.getLong());
    }

    static int asZoneOffset(int encodedZone) {
        if ((0x800000 & encodedZone) == 0x800000) {
            return 0xFF000000 | encodedZone;
        }
        return encodedZone;
    }

    static short asZoneId(int encodedZone) {
        return (short)(encodedZone & 0xFFFFFF);
    }

    static boolean isZoneId(int encodedZone) {
        return (encodedZone & 0x1000000) != 0;
    }
}

