/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.kernel.impl.index.schema.NativeIndexSingleValueKey;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

class LocalTimeIndexKey
extends NativeIndexSingleValueKey<LocalTimeIndexKey> {
    static final int SIZE = 16;
    long nanoOfDay;

    LocalTimeIndexKey() {
    }

    @Override
    public Value asValue() {
        return LocalTimeValue.localTime(this.nanoOfDay);
    }

    @Override
    public void initValueAsLowest(ValueGroup valueGroups) {
        this.nanoOfDay = Long.MIN_VALUE;
    }

    @Override
    public void initValueAsHighest(ValueGroup valueGroups) {
        this.nanoOfDay = Long.MAX_VALUE;
    }

    @Override
    public int compareValueTo(LocalTimeIndexKey other2) {
        return Long.compare(this.nanoOfDay, other2.nanoOfDay);
    }

    public String toString() {
        return String.format("value=%s,entityId=%d,nanoOfDay=%d", this.asValue(), this.getEntityId(), this.nanoOfDay);
    }

    @Override
    public void writeLocalTime(long nanoOfDay) {
        this.nanoOfDay = nanoOfDay;
    }

    @Override
    protected Value assertCorrectType(Value value2) {
        if (!(value2 instanceof LocalTimeValue)) {
            throw new IllegalArgumentException("Key layout does only support LocalTimeValue, tried to create key from " + value2);
        }
        return value2;
    }
}

