/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.labelscan;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntFunction;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.neo4j.cursor.RawCursor;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.kernel.api.labelscan.AllEntriesLabelScanReader;
import org.neo4j.kernel.api.labelscan.NodeLabelRange;
import org.neo4j.kernel.impl.index.labelscan.LabelScanKey;
import org.neo4j.kernel.impl.index.labelscan.LabelScanValue;

class NativeAllEntriesLabelScanReader
implements AllEntriesLabelScanReader {
    private final IntFunction<RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException>> seekProvider;
    private final List<RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException>> cursors = new ArrayList<RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException>>();
    private final int highestLabelId;

    NativeAllEntriesLabelScanReader(IntFunction<RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException>> seekProvider, int highestLabelId) {
        this.seekProvider = seekProvider;
        this.highestLabelId = highestLabelId;
    }

    @Override
    public long maxCount() {
        return -1L;
    }

    @Override
    public int rangeSize() {
        return 64;
    }

    @Override
    public Iterator<NodeLabelRange> iterator() {
        try {
            long lowestRange = Long.MAX_VALUE;
            this.closeCursors();
            for (int labelId = 0; labelId <= this.highestLabelId; ++labelId) {
                RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException> cursor = this.seekProvider.apply(labelId);
                if (!cursor.next()) continue;
                lowestRange = Long.min(lowestRange, ((LabelScanKey)((Hit)cursor.get()).key()).idRange);
                this.cursors.add(cursor);
            }
            return new NodeLabelRangeIterator(lowestRange);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void closeCursors() throws IOException {
        for (RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException> cursor : this.cursors) {
            cursor.close();
        }
        this.cursors.clear();
    }

    @Override
    public void close() throws Exception {
        this.closeCursors();
    }

    private class NodeLabelRangeIterator
    extends PrefetchingIterator<NodeLabelRange> {
        private long currentRange;
        private final MutableLongList[] labelsForEachNode = new MutableLongList[64];

        NodeLabelRangeIterator(long lowestRange) {
            this.currentRange = lowestRange;
        }

        protected NodeLabelRange fetchNextOrNull() {
            if (this.currentRange == Long.MAX_VALUE) {
                return null;
            }
            Arrays.fill(this.labelsForEachNode, null);
            long nextLowestRange = Long.MAX_VALUE;
            try {
                for (RawCursor cursor : NativeAllEntriesLabelScanReader.this.cursors) {
                    long idRange = ((LabelScanKey)((Hit)cursor.get()).key()).idRange;
                    if (idRange < this.currentRange) {
                        assert (!cursor.next());
                        continue;
                    }
                    if (idRange == this.currentRange) {
                        long bits2 = ((LabelScanValue)((Hit)cursor.get()).value()).bits;
                        long labelId = ((LabelScanKey)((Hit)cursor.get()).key()).labelId;
                        NodeLabelRange.readBitmap(bits2, labelId, this.labelsForEachNode);
                        if (!cursor.next()) continue;
                        nextLowestRange = Long.min(nextLowestRange, ((LabelScanKey)((Hit)cursor.get()).key()).idRange);
                        continue;
                    }
                    nextLowestRange = Long.min(nextLowestRange, ((LabelScanKey)((Hit)cursor.get()).key()).idRange);
                }
                NodeLabelRange range2 = new NodeLabelRange(this.currentRange, NodeLabelRange.convertState((LongList[])this.labelsForEachNode));
                this.currentRange = nextLowestRange;
                return range2;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

