/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.neo4j.kernel.configuration.ConfigurationMigrator;
import org.neo4j.logging.Log;

public class BaseConfigurationMigrator
implements ConfigurationMigrator {
    private final List<Migration> migrations = new ArrayList<Migration>();

    public void add(Migration migration2) {
        this.migrations.add(migration2);
    }

    @Override
    @Nonnull
    public Map<String, String> apply(@Nonnull Map<String, String> rawConfiguration, @Nonnull Log log) {
        boolean printedDeprecationMessage = false;
        for (Migration migration2 : this.migrations) {
            if (!migration2.appliesTo(rawConfiguration)) continue;
            if (!printedDeprecationMessage) {
                printedDeprecationMessage = true;
                log.warn("WARNING! Deprecated configuration options used. See manual for details");
            }
            rawConfiguration = migration2.apply(rawConfiguration);
            log.warn(migration2.getDeprecationMessage());
        }
        return rawConfiguration;
    }

    public static abstract class SpecificPropertyMigration
    implements Migration {
        private final String propertyKey;
        private final String deprecationMessage;

        SpecificPropertyMigration(String propertyKey, String deprecationMessage) {
            this.propertyKey = propertyKey;
            this.deprecationMessage = deprecationMessage;
        }

        @Override
        public boolean appliesTo(Map<String, String> rawConfiguration) {
            return rawConfiguration.containsKey(this.propertyKey);
        }

        @Override
        public Map<String, String> apply(Map<String, String> rawConfiguration) {
            String value2 = rawConfiguration.remove(this.propertyKey);
            this.setValueWithOldSetting(value2, rawConfiguration);
            return rawConfiguration;
        }

        @Override
        public String getDeprecationMessage() {
            return this.deprecationMessage;
        }

        public abstract void setValueWithOldSetting(String var1, Map<String, String> var2);
    }

    public static interface Migration {
        public boolean appliesTo(Map<String, String> var1);

        public Map<String, String> apply(Map<String, String> var1);

        public String getDeprecationMessage();
    }
}

