/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.operations;

import java.math.BigDecimal;
import java.util.concurrent.ThreadLocalRandom;
import org.neo4j.cypher.internal.runtime.DbAccess;
import org.neo4j.cypher.internal.v3_5.util.CypherTypeException;
import org.neo4j.cypher.internal.v3_5.util.InvalidArgumentException;
import org.neo4j.cypher.internal.v3_5.util.ParameterWrongTypeException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.utils.InvalidValuesArgumentException;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import org.neo4j.values.virtual.VirtualValues;

public final class CypherFunctions {
    private static final BigDecimal MAX_LONG = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final BigDecimal MIN_LONG = BigDecimal.valueOf(Long.MIN_VALUE);
    private static String[] POINT_KEYS = new String[]{"crs", "x", "y", "z", "longitude", "latitude", "height", "srid"};

    private CypherFunctions() {
        throw new UnsupportedOperationException("Do not instantiate");
    }

    public static DoubleValue sin(AnyValue in2) {
        if (in2 instanceof NumberValue) {
            return Values.doubleValue(Math.sin(((NumberValue)in2).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("sin()");
    }

    public static DoubleValue asin(AnyValue in2) {
        if (in2 instanceof NumberValue) {
            return Values.doubleValue(Math.asin(((NumberValue)in2).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("asin()");
    }

    public static DoubleValue haversin(AnyValue in2) {
        if (in2 instanceof NumberValue) {
            return Values.doubleValue((1.0 - Math.cos(((NumberValue)in2).doubleValue())) / 2.0);
        }
        throw CypherFunctions.needsNumbers("haversin()");
    }

    public static DoubleValue cos(AnyValue in2) {
        if (in2 instanceof NumberValue) {
            return Values.doubleValue(Math.cos(((NumberValue)in2).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("cos()");
    }

    public static DoubleValue cot(AnyValue in2) {
        if (in2 instanceof NumberValue) {
            return Values.doubleValue(1.0 / Math.tan(((NumberValue)in2).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("cot()");
    }

    public static DoubleValue acos(AnyValue in2) {
        if (in2 instanceof NumberValue) {
            return Values.doubleValue(Math.acos(((NumberValue)in2).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("acos()");
    }

    public static DoubleValue tan(AnyValue in2) {
        if (in2 instanceof NumberValue) {
            return Values.doubleValue(Math.tan(((NumberValue)in2).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("tan()");
    }

    public static DoubleValue atan(AnyValue in2) {
        if (in2 instanceof NumberValue) {
            return Values.doubleValue(Math.atan(((NumberValue)in2).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("atan()");
    }

    public static DoubleValue atan2(AnyValue y, AnyValue x) {
        if (y instanceof NumberValue && x instanceof NumberValue) {
            return Values.doubleValue(Math.atan2(((NumberValue)y).doubleValue(), ((NumberValue)x).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("atan2()");
    }

    public static DoubleValue ceil(AnyValue in2) {
        if (in2 instanceof NumberValue) {
            return Values.doubleValue(Math.ceil(((NumberValue)in2).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("ceil()");
    }

    public static DoubleValue floor(AnyValue in2) {
        if (in2 instanceof NumberValue) {
            return Values.doubleValue(Math.floor(((NumberValue)in2).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("floor()");
    }

    public static DoubleValue round(AnyValue in2) {
        if (in2 instanceof NumberValue) {
            return Values.doubleValue(Math.round(((NumberValue)in2).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("round()");
    }

    public static NumberValue abs(AnyValue in2) {
        if (in2 instanceof NumberValue) {
            if (in2 instanceof IntegralValue) {
                return Values.longValue(Math.abs(((NumberValue)in2).longValue()));
            }
            return Values.doubleValue(Math.abs(((NumberValue)in2).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("abs()");
    }

    public static DoubleValue toDegrees(AnyValue in2) {
        if (in2 instanceof NumberValue) {
            return Values.doubleValue(Math.toDegrees(((NumberValue)in2).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("toDegrees()");
    }

    public static DoubleValue exp(AnyValue in2) {
        if (in2 instanceof NumberValue) {
            return Values.doubleValue(Math.exp(((NumberValue)in2).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("exp()");
    }

    public static DoubleValue log(AnyValue in2) {
        if (in2 instanceof NumberValue) {
            return Values.doubleValue(Math.log(((NumberValue)in2).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("log()");
    }

    public static DoubleValue log10(AnyValue in2) {
        if (in2 instanceof NumberValue) {
            return Values.doubleValue(Math.log10(((NumberValue)in2).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("log10()");
    }

    public static DoubleValue toRadians(AnyValue in2) {
        if (in2 instanceof NumberValue) {
            return Values.doubleValue(Math.toRadians(((NumberValue)in2).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("toRadians()");
    }

    public static ListValue range(AnyValue startValue, AnyValue endValue) {
        return VirtualValues.range(CypherFunctions.asLong(startValue), CypherFunctions.asLong(endValue), 1L);
    }

    public static ListValue range(AnyValue startValue, AnyValue endValue, AnyValue stepValue) {
        long step = CypherFunctions.asLong(stepValue);
        if (step == 0L) {
            throw new InvalidArgumentException("step argument to range() cannot be zero", null);
        }
        return VirtualValues.range(CypherFunctions.asLong(startValue), CypherFunctions.asLong(endValue), step);
    }

    public static LongValue signum(AnyValue in2) {
        if (in2 instanceof NumberValue) {
            return Values.longValue((long)Math.signum(((NumberValue)in2).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("signum()");
    }

    public static DoubleValue sqrt(AnyValue in2) {
        if (in2 instanceof NumberValue) {
            return Values.doubleValue(Math.sqrt(((NumberValue)in2).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("sqrt()");
    }

    public static DoubleValue rand() {
        return Values.doubleValue(ThreadLocalRandom.current().nextDouble());
    }

    public static Value distance(AnyValue lhs, AnyValue rhs) {
        if (lhs instanceof PointValue && rhs instanceof PointValue) {
            return CypherFunctions.calculateDistance((PointValue)lhs, (PointValue)rhs);
        }
        return Values.NO_VALUE;
    }

    public static NodeValue startNode(AnyValue anyValue, DbAccess access) {
        if (anyValue instanceof RelationshipValue) {
            return access.relationshipGetStartNode((RelationshipValue)anyValue);
        }
        throw new CypherTypeException(String.format("Expected %s to be a RelationshipValue", anyValue), null);
    }

    public static NodeValue endNode(AnyValue anyValue, DbAccess access) {
        if (anyValue instanceof RelationshipValue) {
            return access.relationshipGetEndNode((RelationshipValue)anyValue);
        }
        throw new CypherTypeException(String.format("Expected %s to be a RelationshipValue", anyValue), null);
    }

    public static BooleanValue propertyExists(String key, AnyValue container, DbAccess dbAccess) {
        if (container instanceof VirtualNodeValue) {
            return dbAccess.nodeHasProperty(((VirtualNodeValue)container).id(), dbAccess.propertyKey(key)) ? Values.TRUE : Values.FALSE;
        }
        if (container instanceof VirtualRelationshipValue) {
            return dbAccess.relationshipHasProperty(((VirtualRelationshipValue)container).id(), dbAccess.propertyKey(key)) ? Values.TRUE : Values.FALSE;
        }
        if (container instanceof MapValue) {
            return ((MapValue)container).get(key) != Values.NO_VALUE ? Values.TRUE : Values.FALSE;
        }
        throw new CypherTypeException(String.format("Expected %s to be a property container", container), null);
    }

    public static AnyValue propertyGet(String key, AnyValue container, DbAccess dbAccess) {
        if (container instanceof VirtualNodeValue) {
            return dbAccess.nodeProperty(((VirtualNodeValue)container).id(), dbAccess.propertyKey(key));
        }
        if (container instanceof VirtualRelationshipValue) {
            return dbAccess.relationshipProperty(((VirtualRelationshipValue)container).id(), dbAccess.propertyKey(key));
        }
        if (container instanceof MapValue) {
            return ((MapValue)container).get(key);
        }
        if (container instanceof TemporalValue) {
            return ((TemporalValue)container).get(key);
        }
        if (container instanceof DurationValue) {
            return ((DurationValue)container).get(key);
        }
        if (container instanceof PointValue) {
            try {
                return ((PointValue)container).get(key);
            }
            catch (InvalidValuesArgumentException e) {
                throw new InvalidArgumentException(e.getMessage(), e);
            }
        }
        throw new CypherTypeException(String.format("Type mismatch: expected a map but was %s", container.toString()), null);
    }

    public static AnyValue containerIndex(AnyValue container, AnyValue index, DbAccess dbAccess) {
        if (container instanceof VirtualNodeValue) {
            return dbAccess.nodeProperty(((VirtualNodeValue)container).id(), dbAccess.propertyKey(CypherFunctions.asString(index)));
        }
        if (container instanceof VirtualRelationshipValue) {
            return dbAccess.relationshipProperty(((VirtualRelationshipValue)container).id(), dbAccess.propertyKey(CypherFunctions.asString(index)));
        }
        if (container instanceof MapValue) {
            return CypherFunctions.mapAccess((MapValue)container, index);
        }
        if (container instanceof SequenceValue) {
            return CypherFunctions.listAccess((SequenceValue)((Object)container), index);
        }
        throw new CypherTypeException(String.format("`%s` is not a collection or a map. Element access is only possible by performing a collection lookup using an integer index, or by performing a map lookup using a string key (found: %s[%s])", container, container, index), null);
    }

    public static AnyValue head(AnyValue container) {
        if (container instanceof SequenceValue) {
            SequenceValue sequence2 = (SequenceValue)((Object)container);
            if (sequence2.length() == 0) {
                return Values.NO_VALUE;
            }
            return sequence2.value(0);
        }
        throw new CypherTypeException(String.format("Expected %s to be a list", container), null);
    }

    public static ListValue tail(AnyValue container) {
        if (container instanceof ListValue) {
            return ((ListValue)container).tail();
        }
        if (container instanceof ArrayValue) {
            return VirtualValues.fromArray((ArrayValue)container).tail();
        }
        return VirtualValues.EMPTY_LIST;
    }

    public static AnyValue last(AnyValue container) {
        if (container instanceof SequenceValue) {
            SequenceValue sequence2 = (SequenceValue)((Object)container);
            int length2 = sequence2.length();
            if (length2 == 0) {
                return Values.NO_VALUE;
            }
            return sequence2.value(length2 - 1);
        }
        throw new CypherTypeException(String.format("Expected %s to be a list", container), null);
    }

    public static TextValue left(AnyValue in2, AnyValue endPos) {
        if (in2 instanceof TextValue) {
            int len = CypherFunctions.asInt(endPos);
            return ((TextValue)in2).substring(0, len);
        }
        throw CypherFunctions.notAString("left", in2);
    }

    public static TextValue ltrim(AnyValue in2) {
        if (in2 instanceof TextValue) {
            return ((TextValue)in2).ltrim();
        }
        throw CypherFunctions.notAString("ltrim", in2);
    }

    public static TextValue rtrim(AnyValue in2) {
        if (in2 instanceof TextValue) {
            return ((TextValue)in2).rtrim();
        }
        throw CypherFunctions.notAString("rtrim", in2);
    }

    public static TextValue trim(AnyValue in2) {
        if (in2 instanceof TextValue) {
            return ((TextValue)in2).trim();
        }
        throw CypherFunctions.notAString("trim", in2);
    }

    public static TextValue replace(AnyValue original, AnyValue search, AnyValue replaceWith) {
        if (original instanceof TextValue) {
            return ((TextValue)original).replace(CypherFunctions.asString(search), CypherFunctions.asString(replaceWith));
        }
        throw CypherFunctions.notAString("replace", original);
    }

    public static AnyValue reverse(AnyValue original) {
        if (original instanceof TextValue) {
            return ((TextValue)original).reverse();
        }
        if (original instanceof ListValue) {
            return ((ListValue)original).reverse();
        }
        throw new CypherTypeException("Expected a string or a list; consider converting it to a string with toString() or creating a list.", null);
    }

    public static TextValue right(AnyValue original, AnyValue length2) {
        if (original instanceof TextValue) {
            TextValue asText = (TextValue)original;
            int len = CypherFunctions.asInt(length2);
            if (len < 0) {
                throw new IndexOutOfBoundsException("negative length");
            }
            int startVal = asText.length() - len;
            return asText.substring(Math.max(0, startVal));
        }
        throw CypherFunctions.notAString("right", original);
    }

    public static ListValue split(AnyValue original, AnyValue separator) {
        if (original instanceof TextValue) {
            TextValue asText = (TextValue)original;
            if (asText.length() == 0) {
                return VirtualValues.list(Values.EMPTY_STRING);
            }
            return asText.split(CypherFunctions.asString(separator));
        }
        throw CypherFunctions.notAString("split", original);
    }

    public static TextValue substring(AnyValue original, AnyValue start) {
        if (original instanceof TextValue) {
            TextValue asText = (TextValue)original;
            return asText.substring(CypherFunctions.asInt(start));
        }
        throw CypherFunctions.notAString("substring", original);
    }

    public static TextValue substring(AnyValue original, AnyValue start, AnyValue length2) {
        if (original instanceof TextValue) {
            TextValue asText = (TextValue)original;
            return asText.substring(CypherFunctions.asInt(start), CypherFunctions.asInt(length2));
        }
        throw CypherFunctions.notAString("substring", original);
    }

    public static TextValue toLower(AnyValue in2) {
        if (in2 instanceof TextValue) {
            return ((TextValue)in2).toLower();
        }
        throw CypherFunctions.notAString("toLower", in2);
    }

    public static TextValue toUpper(AnyValue in2) {
        if (in2 instanceof TextValue) {
            return ((TextValue)in2).toUpper();
        }
        throw CypherFunctions.notAString("toUpper", in2);
    }

    public static LongValue id(AnyValue item) {
        if (item instanceof VirtualNodeValue) {
            return Values.longValue(((VirtualNodeValue)item).id());
        }
        if (item instanceof VirtualRelationshipValue) {
            return Values.longValue(((VirtualRelationshipValue)item).id());
        }
        throw new CypherTypeException(String.format("Expected %s to be a node or relationship, but it was `%s`", item, item.getClass().getSimpleName()), null);
    }

    public static ListValue labels(AnyValue item, DbAccess access) {
        if (item instanceof NodeValue) {
            return access.getLabelsForNode(((NodeValue)item).id());
        }
        throw new ParameterWrongTypeException("Expected a Node, got: " + item, null);
    }

    public static boolean hasLabel(AnyValue entity, int labelToken, DbAccess access) {
        if (entity instanceof NodeValue) {
            return access.isLabelSetOnNode(labelToken, ((NodeValue)entity).id());
        }
        throw new ParameterWrongTypeException("Expected a Node, got: " + entity, null);
    }

    public static TextValue type(AnyValue item) {
        if (item instanceof RelationshipValue) {
            return ((RelationshipValue)item).type();
        }
        throw new ParameterWrongTypeException("Expected a Relationship, got: " + item, null);
    }

    public static ListValue nodes(AnyValue in2) {
        if (in2 instanceof PathValue) {
            return VirtualValues.list(((PathValue)in2).nodes());
        }
        throw new CypherTypeException(String.format("Expected %s to be a path.", in2), null);
    }

    public static ListValue relationships(AnyValue in2) {
        if (in2 instanceof PathValue) {
            return VirtualValues.list(((PathValue)in2).relationships());
        }
        throw new CypherTypeException(String.format("Expected %s to be a path.", in2), null);
    }

    public static Value point(AnyValue in2, DbAccess access) {
        if (in2 instanceof VirtualNodeValue) {
            return CypherFunctions.asPoint(access, (VirtualNodeValue)in2);
        }
        if (in2 instanceof VirtualRelationshipValue) {
            return CypherFunctions.asPoint(access, (VirtualRelationshipValue)in2);
        }
        if (in2 instanceof MapValue) {
            MapValue map2 = (MapValue)in2;
            if (CypherFunctions.containsNull(map2)) {
                return Values.NO_VALUE;
            }
            return PointValue.fromMap(map2);
        }
        throw new CypherTypeException(String.format("Expected a map but got %s", in2), null);
    }

    public static ListValue keys(AnyValue in2, DbAccess access) {
        if (in2 instanceof VirtualNodeValue) {
            return CypherFunctions.extractKeys(access, access.nodePropertyIds(((VirtualNodeValue)in2).id()));
        }
        if (in2 instanceof VirtualRelationshipValue) {
            return CypherFunctions.extractKeys(access, access.relationshipPropertyIds(((VirtualRelationshipValue)in2).id()));
        }
        if (in2 instanceof MapValue) {
            return ((MapValue)in2).keys();
        }
        throw new CypherTypeException(String.format("Expected a node, a relationship or a literal map but got %s", in2), null);
    }

    public static MapValue properties(AnyValue in2, DbAccess access) {
        if (in2 instanceof VirtualNodeValue) {
            return access.nodeAsMap(((VirtualNodeValue)in2).id());
        }
        if (in2 instanceof VirtualRelationshipValue) {
            return access.relationshipAsMap(((VirtualRelationshipValue)in2).id());
        }
        if (in2 instanceof MapValue) {
            return (MapValue)in2;
        }
        throw new CypherTypeException(String.format("Expected a node, a relationship or a literal map but got %s", in2), null);
    }

    public static IntegralValue size(AnyValue item) {
        if (item instanceof PathValue) {
            throw new CypherTypeException("SIZE cannot be used on paths", null);
        }
        if (item instanceof TextValue) {
            return Values.longValue(((TextValue)item).length());
        }
        if (item instanceof SequenceValue) {
            return Values.longValue(((SequenceValue)((Object)item)).length());
        }
        return Values.longValue(1L);
    }

    public static IntegralValue length(AnyValue item) {
        if (item instanceof PathValue) {
            return Values.longValue(((PathValue)item).size());
        }
        if (item instanceof TextValue) {
            return Values.longValue(((TextValue)item).length());
        }
        if (item instanceof SequenceValue) {
            return Values.longValue(((SequenceValue)((Object)item)).length());
        }
        return Values.longValue(1L);
    }

    public static Value toBoolean(AnyValue in2) {
        if (in2 instanceof BooleanValue) {
            return (BooleanValue)in2;
        }
        if (in2 instanceof TextValue) {
            switch (((TextValue)in2).trim().stringValue().toLowerCase()) {
                case "true": {
                    return Values.TRUE;
                }
                case "false": {
                    return Values.FALSE;
                }
            }
            return Values.NO_VALUE;
        }
        throw new ParameterWrongTypeException("Expected a Boolean or String, got: " + in2.toString(), null);
    }

    public static Value toFloat(AnyValue in2) {
        if (in2 instanceof DoubleValue) {
            return (DoubleValue)in2;
        }
        if (in2 instanceof NumberValue) {
            return Values.doubleValue(((NumberValue)in2).doubleValue());
        }
        if (in2 instanceof TextValue) {
            try {
                return Values.doubleValue(Double.parseDouble(((TextValue)in2).stringValue()));
            }
            catch (NumberFormatException ignore) {
                return Values.NO_VALUE;
            }
        }
        throw new ParameterWrongTypeException("Expected a String or Number, got: " + in2.toString(), null);
    }

    public static Value toInteger(AnyValue in2) {
        if (in2 instanceof IntegralValue) {
            return (IntegralValue)in2;
        }
        if (in2 instanceof NumberValue) {
            return Values.longValue(((NumberValue)in2).longValue());
        }
        if (in2 instanceof TextValue) {
            return CypherFunctions.stringToLongValue((TextValue)in2);
        }
        throw new ParameterWrongTypeException("Expected a String or Number, got: " + in2.toString(), null);
    }

    public static TextValue toString(AnyValue in2) {
        if (in2 instanceof TextValue) {
            return (TextValue)in2;
        }
        if (in2 instanceof NumberValue) {
            return Values.stringValue(((NumberValue)in2).prettyPrint());
        }
        if (in2 instanceof BooleanValue) {
            return Values.stringValue(((BooleanValue)in2).prettyPrint());
        }
        if (in2 instanceof TemporalValue || in2 instanceof DurationValue || in2 instanceof PointValue) {
            return Values.stringValue(in2.toString());
        }
        throw new ParameterWrongTypeException("Expected a String, Number, Boolean, Temporal or Duration, got: " + in2.toString(), null);
    }

    public static ListValue fromSlice(AnyValue collection, AnyValue fromValue) {
        int from2 = CypherFunctions.asInt(fromValue);
        ListValue list2 = CypherFunctions.makeTraversable(collection);
        if (from2 >= 0) {
            return list2.drop(from2);
        }
        return list2.drop(list2.size() + from2);
    }

    public static ListValue toSlice(AnyValue collection, AnyValue fromValue) {
        int from2 = CypherFunctions.asInt(fromValue);
        ListValue list2 = CypherFunctions.makeTraversable(collection);
        if (from2 >= 0) {
            return list2.take(from2);
        }
        return list2.take(list2.size() + from2);
    }

    public static ListValue fullSlice(AnyValue collection, AnyValue fromValue, AnyValue toValue) {
        int from2 = CypherFunctions.asInt(fromValue);
        int to2 = CypherFunctions.asInt(toValue);
        ListValue list2 = CypherFunctions.makeTraversable(collection);
        int size2 = list2.size();
        if (from2 >= 0 && to2 >= 0) {
            return list2.slice(from2, to2);
        }
        if (from2 >= 0) {
            return list2.slice(from2, size2 + to2);
        }
        if (to2 >= 0) {
            return list2.slice(size2 + from2, to2);
        }
        return list2.slice(size2 + from2, size2 + to2);
    }

    public static ListValue makeTraversable(AnyValue collection) {
        if (collection == Values.NO_VALUE) {
            return VirtualValues.EMPTY_LIST;
        }
        if (collection instanceof ListValue) {
            return (ListValue)collection;
        }
        if (collection instanceof ArrayValue) {
            return VirtualValues.fromArray((ArrayValue)collection);
        }
        return VirtualValues.list(collection);
    }

    private static Value stringToLongValue(TextValue in2) {
        try {
            return Values.longValue(Long.parseLong(in2.stringValue()));
        }
        catch (Exception e) {
            try {
                BigDecimal bigDecimal = new BigDecimal(in2.stringValue());
                if (bigDecimal.compareTo(MAX_LONG) <= 0 && bigDecimal.compareTo(MIN_LONG) >= 0) {
                    return Values.longValue(bigDecimal.longValue());
                }
                throw new CypherTypeException(String.format("integer, %s, is too large", in2.stringValue()), null);
            }
            catch (NumberFormatException ignore) {
                return Values.NO_VALUE;
            }
        }
    }

    private static ListValue extractKeys(DbAccess access, int[] keyIds) {
        String[] keysNames = new String[keyIds.length];
        for (int i = 0; i < keyIds.length; ++i) {
            keysNames[i] = access.getPropertyKeyName(keyIds[i]);
        }
        return VirtualValues.fromArray(Values.stringArray(keysNames));
    }

    private static Value asPoint(DbAccess access, VirtualNodeValue nodeValue) {
        MapValueBuilder builder = new MapValueBuilder();
        for (String key : POINT_KEYS) {
            Value value2 = access.nodeProperty(nodeValue.id(), access.propertyKey(key));
            if (value2 == Values.NO_VALUE) continue;
            builder.add(key, value2);
        }
        return PointValue.fromMap(builder.build());
    }

    private static Value asPoint(DbAccess access, VirtualRelationshipValue relationshipValue) {
        MapValueBuilder builder = new MapValueBuilder();
        for (String key : POINT_KEYS) {
            Value value2 = access.relationshipProperty(relationshipValue.id(), access.propertyKey(key));
            if (value2 == Values.NO_VALUE) continue;
            builder.add(key, value2);
        }
        return PointValue.fromMap(builder.build());
    }

    private static boolean containsNull(MapValue map2) {
        boolean[] hasNull = new boolean[]{false};
        map2.foreach((s2, value2) -> {
            if (value2 == Values.NO_VALUE) {
                hasNull[0] = true;
            }
        });
        return hasNull[0];
    }

    private static AnyValue listAccess(SequenceValue container, AnyValue index) {
        NumberValue number = CypherFunctions.asNumberValue(index);
        if (!(number instanceof IntegralValue)) {
            throw new CypherTypeException(String.format("Cannot index a list using an non-integer number, got %s", number), null);
        }
        long idx = number.longValue();
        if (idx > Integer.MAX_VALUE || idx < Integer.MIN_VALUE) {
            throw new InvalidArgumentException(String.format("Cannot index a list using a value greater than %d or lesser than %d, got %d", Integer.MAX_VALUE, Integer.MIN_VALUE, idx), null);
        }
        if (idx < 0L) {
            idx = (long)container.length() + idx;
        }
        if (idx >= (long)container.length() || idx < 0L) {
            return Values.NO_VALUE;
        }
        return container.value((int)idx);
    }

    private static AnyValue mapAccess(MapValue container, AnyValue index) {
        return container.get(CypherFunctions.asString(index));
    }

    public static TextValue asTextValue(AnyValue value2) {
        if (!(value2 instanceof TextValue)) {
            throw new CypherTypeException(String.format("Expected %s to be a %s, but it was a %s", value2, TextValue.class.getName(), value2.getClass().getName()), null);
        }
        return (TextValue)value2;
    }

    static String asString(AnyValue value2) {
        return CypherFunctions.asTextValue(value2).stringValue();
    }

    private static NumberValue asNumberValue(AnyValue value2) {
        if (!(value2 instanceof NumberValue)) {
            throw new CypherTypeException(String.format("Expected %s to be a %s, but it was a %s", value2, NumberValue.class.getName(), value2.getClass().getName()), null);
        }
        return (NumberValue)value2;
    }

    private static Value calculateDistance(PointValue p1, PointValue p2) {
        if (p1.getCoordinateReferenceSystem().equals(p2.getCoordinateReferenceSystem())) {
            return Values.doubleValue(p1.getCoordinateReferenceSystem().getCalculator().distance(p1, p2));
        }
        return Values.NO_VALUE;
    }

    private static long asLong(AnyValue value2) {
        if (value2 instanceof NumberValue) {
            return ((NumberValue)value2).longValue();
        }
        throw new CypherTypeException("Expected a numeric value but got: " + value2.toString(), null);
    }

    private static int asInt(AnyValue value2) {
        return (int)CypherFunctions.asLong(value2);
    }

    private static CypherTypeException needsNumbers(String method) {
        return new CypherTypeException(String.format("%s requires numbers", method), null);
    }

    private static CypherTypeException notAString(String method, AnyValue in2) {
        return new CypherTypeException(String.format("Expected a string value for `%s`, but got: %s; consider converting it to a string with toString().", method, in2), null);
    }
}

