/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.runtime;

import java.time.Clock;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.runtime.BoltConnectionFactory;
import org.neo4j.bolt.runtime.BoltConnectionMetricsMonitor;
import org.neo4j.bolt.runtime.BoltConnectionQueueMonitorAggregate;
import org.neo4j.bolt.runtime.BoltConnectionReadLimiter;
import org.neo4j.bolt.runtime.BoltScheduler;
import org.neo4j.bolt.runtime.BoltSchedulerProvider;
import org.neo4j.bolt.runtime.DefaultBoltConnection;
import org.neo4j.bolt.runtime.MetricsReportingBoltConnection;
import org.neo4j.bolt.transport.TransportThrottleGroup;
import org.neo4j.bolt.v1.runtime.BoltFactory;
import org.neo4j.bolt.v1.transport.ChunkedOutput;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.monitoring.Monitors;

public class DefaultBoltConnectionFactory
implements BoltConnectionFactory {
    private final BoltFactory machineFactory;
    private final BoltSchedulerProvider schedulerProvider;
    private final TransportThrottleGroup throttleGroup;
    private final LogService logService;
    private final Clock clock;
    private final Config config;
    private final Monitors monitors;
    private final BoltConnectionMetricsMonitor metricsMonitor;

    public DefaultBoltConnectionFactory(BoltFactory machineFactory, BoltSchedulerProvider schedulerProvider, TransportThrottleGroup throttleGroup, Config config, LogService logService, Clock clock, Monitors monitors) {
        this.machineFactory = machineFactory;
        this.schedulerProvider = schedulerProvider;
        this.throttleGroup = throttleGroup;
        this.config = config;
        this.logService = logService;
        this.clock = clock;
        this.monitors = monitors;
        this.metricsMonitor = (BoltConnectionMetricsMonitor)monitors.newMonitor(BoltConnectionMetricsMonitor.class, new String[0]);
    }

    @Override
    public BoltConnection newConnection(BoltChannel channel) {
        BoltScheduler scheduler = this.schedulerProvider.get(channel);
        BoltConnectionReadLimiter readLimiter = DefaultBoltConnectionFactory.createReadLimiter(this.config, this.logService);
        BoltConnectionQueueMonitorAggregate connectionQueueMonitor = new BoltConnectionQueueMonitorAggregate(scheduler, readLimiter);
        ChunkedOutput chunkedOutput = new ChunkedOutput(channel.rawChannel(), this.throttleGroup);
        DefaultBoltConnection connection = this.monitors.hasListeners(BoltConnectionMetricsMonitor.class) ? new MetricsReportingBoltConnection(channel, chunkedOutput, this.machineFactory.newMachine(channel, this.clock), this.logService, scheduler, connectionQueueMonitor, this.metricsMonitor, this.clock) : new DefaultBoltConnection(channel, chunkedOutput, this.machineFactory.newMachine(channel, this.clock), this.logService, scheduler, connectionQueueMonitor);
        connection.start();
        return connection;
    }

    private static BoltConnectionReadLimiter createReadLimiter(Config config, LogService logService) {
        int lowWatermark = (Integer)config.get(GraphDatabaseSettings.bolt_inbound_message_throttle_low_water_mark);
        int highWatermark = (Integer)config.get(GraphDatabaseSettings.bolt_inbound_message_throttle_high_water_mark);
        return new BoltConnectionReadLimiter(logService, lowWatermark, highWatermark);
    }
}

