/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs.watcher;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.watcher.FileWatchEventListener;
import org.neo4j.io.fs.watcher.FileWatcher;
import org.neo4j.io.fs.watcher.resource.WatchedResource;

public class RestartableFileSystemWatcher
implements FileWatcher {
    private FileWatcher delegate;
    private Set<File> filesToWatch = Collections.newSetFromMap(new ConcurrentHashMap());
    private Set<WatchedResource> watchedResources = Collections.newSetFromMap(new ConcurrentHashMap());

    public RestartableFileSystemWatcher(FileWatcher delegate) {
        this.delegate = delegate;
    }

    @Override
    public WatchedResource watch(File file) {
        this.filesToWatch.add(file);
        return WatchedResource.EMPTY;
    }

    @Override
    public void addFileWatchEventListener(FileWatchEventListener listener) {
        this.delegate.addFileWatchEventListener(listener);
    }

    @Override
    public void removeFileWatchEventListener(FileWatchEventListener listener) {
        this.delegate.removeFileWatchEventListener(listener);
    }

    @Override
    public void stopWatching() {
        try {
            IOUtils.closeAll(this.watchedResources);
            this.watchedResources.clear();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            this.delegate.stopWatching();
        }
    }

    @Override
    public void startWatching() throws InterruptedException {
        for (File fileToWatch : this.filesToWatch) {
            this.watchFile(fileToWatch);
        }
        this.delegate.startWatching();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    private void watchFile(File fileToWatch) {
        try {
            this.watchedResources.add(this.delegate.watch(fileToWatch));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

