@if "%DEBUG%" == "" @echo off
rem Copyright (c) 2018-2020 "Graph Foundation,"
rem Graph Foundation, Inc. [https://graphfoundation.org]
rem
rem This file is part of ONgDB.
rem
rem ONgDB is free software: you can redistribute it and/or modify
rem it under the terms of the GNU General Public License as published by
rem the Free Software Foundation, either version 3 of the License, or
rem (at your option) any later version.
rem
rem This program is distributed in the hope that it will be useful,
rem but WITHOUT ANY WARRANTY; without even the implied warranty of
rem MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
rem GNU General Public License for more details.

rem ##########################################################################
rem
rem  geequel-shell startup script for Windows
rem
rem ##########################################################################

rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%" == "" set DIRNAME=.
set APP_BASE_NAME=%~n0
set ONGDB_HOME=%DIRNAME%..

rem Add default JVM options here. You can also use JAVA_OPTS and GEEQUEL_SHELL_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if "%ERRORLEVEL%" == "0" goto init

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto init

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:init
rem Get command-line arguments, handling Windows variants

if not "%OS%" == "Windows_NT" goto win9xME_args
if "%@eval[2+2]" == "4" goto 4NT_args

:win9xME_args
rem Slurp the command line arguments.
set CMD_LINE_ARGS=
set _SKIP=2

:win9xME_args_slurp
if "x%~1" == "x" goto execute

set CMD_LINE_ARGS=%*
goto execute

:4NT_args
rem Get arguments from the 4NT Shell from JP Software
set CMD_LINE_ARGS=%$

:execute
rem Setup the command line

SETLOCAL EnableDelayedExpansion
SET GEEQUEL_SHELL_JAR=
FOR /f "delims=" %%a in ('dir "%ONGDB_HOME%\geequel-shell.jar" /s/b') do set GEEQUEL_SHELL_JAR=!GEEQUEL_SHELL_JAR!%%a

rem Execute geequel-shell
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %GEEQUEL_SHELL_OPTS%  -jar "%GEEQUEL_SHELL_JAR%" %CMD_LINE_ARGS%

:end
rem End local scope for the variables with windows NT shell
if "%ERRORLEVEL%"=="0" goto mainEnd

:fail
rem Set variable GEEQUEL_SHELL_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
if  not "" == "%GEEQUEL_SHELL_EXIT_CONSOLE%" exit 1
exit /b 1

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
