/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.function.IntFunction;
import org.neo4j.kernel.impl.index.schema.fusion.InstanceSelector;

class LazyInstanceSelector<T>
extends InstanceSelector<T> {
    private final IntFunction<T> factory;

    LazyInstanceSelector(T[] instances, IntFunction<T> factory) {
        super(instances);
        this.factory = factory;
    }

    @Override
    T select(int slot) {
        if (this.instances[slot] == null) {
            this.assertOpen();
            this.instances[slot] = this.factory.apply(slot);
        }
        return super.select(slot);
    }

    T getIfInstantiated(int slot) {
        return (T)this.instances[slot];
    }

    private void assertOpen() {
        if (this.closed) {
            throw new IllegalStateException("This selector has been closed");
        }
    }
}

