/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.configuration.ConfigValue;
import org.neo4j.gis.spatial.index.Envelope;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettings;
import org.neo4j.kernel.impl.index.schema.config.SpatialIndexSettings;
import org.neo4j.values.storable.CoordinateReferenceSystem;

public class SpaceFillingCurveSettingsFactory {
    private int maxBits;
    private HashMap<CoordinateReferenceSystem, SpaceFillingCurveSettings> settings = new HashMap();
    private static final double DEFAULT_MIN_EXTENT = -1000000.0;
    private static final double DEFAULT_MAX_EXTENT = 1000000.0;
    private static final double DEFAULT_MIN_LATITUDE = -90.0;
    private static final double DEFAULT_MAX_LATITUDE = 90.0;
    private static final double DEFAULT_MIN_LONGITUDE = -180.0;
    private static final double DEFAULT_MAX_LONGITUDE = 180.0;
    private static final String SPATIAL_SETTING_PREFIX = "unsupported.dbms.db.spatial.crs.";

    public SpaceFillingCurveSettingsFactory(Config config) {
        this.maxBits = config.get(SpatialIndexSettings.space_filling_curve_max_bits);
        HashMap<CoordinateReferenceSystem, EnvelopeSettings> env = new HashMap<CoordinateReferenceSystem, EnvelopeSettings>();
        block8: for (Map.Entry<String, ConfigValue> entry : config.getConfigValues().entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue().toString();
            if (!key.startsWith(SPATIAL_SETTING_PREFIX)) continue;
            String[] fields = key.replace(SPATIAL_SETTING_PREFIX, "").split("\\.");
            if (fields.length != 3) {
                throw new IllegalArgumentException("Invalid spatial config settings, expected three fields after 'unsupported.dbms.db.spatial.crs.': " + key);
            }
            CoordinateReferenceSystem crs = CoordinateReferenceSystem.byName((String)fields[0]);
            EnvelopeSettings envelopeSettings = env.computeIfAbsent(crs, x$0 -> new EnvelopeSettings((CoordinateReferenceSystem)x$0));
            int index = "xyz".indexOf(fields[1].toLowerCase());
            if (index < 0) {
                throw new IllegalArgumentException("Invalid spatial coordinate key (should be one of 'x', 'y' or 'z'): " + fields[1]);
            }
            if (index >= crs.getDimension()) {
                throw new IllegalArgumentException("Invalid spatial coordinate key for " + crs.getDimension() + "D: " + fields[1]);
            }
            switch (fields[2].toLowerCase()) {
                case "min": {
                    envelopeSettings.min[index] = Double.parseDouble(value);
                    continue block8;
                }
                case "max": {
                    envelopeSettings.max[index] = Double.parseDouble(value);
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Invalid spatial coordinate range key (should be one of 'max' or 'min'): " + fields[2]);
        }
        for (Map.Entry<String, Object> entry : env.entrySet()) {
            CoordinateReferenceSystem crs = (CoordinateReferenceSystem)entry.getKey();
            this.settings.put(crs, SpaceFillingCurveSettings.fromConfig(crs.getDimension(), this.maxBits, ((EnvelopeSettings)entry.getValue()).asEnvelope()));
        }
    }

    public SpaceFillingCurveSettings settingsFor(CoordinateReferenceSystem crs) {
        if (this.settings.containsKey(crs)) {
            return this.settings.get(crs);
        }
        return SpaceFillingCurveSettings.fromConfig(crs.getDimension(), this.maxBits, SpaceFillingCurveSettingsFactory.envelopeFromCRS(crs.getDimension(), crs.isGeographic(), new EnvelopeSettings(crs)));
    }

    private static Envelope envelopeFromCRS(int dimension, boolean geographic, EnvelopeSettings envelopeSettings) {
        assert (dimension >= 2);
        double[] min = new double[dimension];
        double[] max = new double[dimension];
        int cartesianStartIndex = 0;
        if (geographic) {
            min[0] = SpaceFillingCurveSettingsFactory.valOrDefault(envelopeSettings.min[0], -180.0);
            max[0] = SpaceFillingCurveSettingsFactory.valOrDefault(envelopeSettings.max[0], 180.0);
            min[1] = SpaceFillingCurveSettingsFactory.valOrDefault(envelopeSettings.min[1], -90.0);
            max[1] = SpaceFillingCurveSettingsFactory.valOrDefault(envelopeSettings.max[1], 90.0);
            cartesianStartIndex = 2;
        }
        for (int i = cartesianStartIndex; i < dimension; ++i) {
            min[i] = SpaceFillingCurveSettingsFactory.valOrDefault(envelopeSettings.min[i], -1000000.0);
            max[i] = SpaceFillingCurveSettingsFactory.valOrDefault(envelopeSettings.max[i], 1000000.0);
        }
        return new Envelope(min, max);
    }

    private static double valOrDefault(double val, double def) {
        return Double.isNaN(val) ? def : val;
    }

    private class EnvelopeSettings {
        CoordinateReferenceSystem crs;
        double[] min;
        double[] max;

        EnvelopeSettings(CoordinateReferenceSystem crs) {
            this.crs = crs;
            this.min = new double[crs.getDimension()];
            this.max = new double[crs.getDimension()];
            Arrays.fill(this.min, Double.NaN);
            Arrays.fill(this.max, Double.NaN);
        }

        Envelope asEnvelope() {
            return SpaceFillingCurveSettingsFactory.envelopeFromCRS(this.crs.getDimension(), this.crs.isGeographic(), this);
        }
    }
}

