/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.domain;

import java.util.Collection;
import java.util.Map;

public class HtmlHelper {
    private static final String STYLE_LOCATION = "http://resthtml.neo4j.org/style/";

    private HtmlHelper() {
    }

    public static String from(Object object, ObjectType objectType) {
        StringBuilder builder = HtmlHelper.start(objectType, null);
        HtmlHelper.append(builder, object, objectType);
        return HtmlHelper.end(builder);
    }

    public static StringBuilder start(ObjectType objectType, String additionalCodeInHead) {
        return HtmlHelper.start(objectType.getCaption(), additionalCodeInHead);
    }

    public static StringBuilder start(String title, String additionalCodeInHead) {
        StringBuilder builder = new StringBuilder();
        builder.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n");
        builder.append("<html><head><title>" + title + "</title>");
        if (additionalCodeInHead != null) {
            builder.append(additionalCodeInHead);
        }
        builder.append("<meta content=\"text/html; charset=utf-8\" http-equiv=\"Content-Type\">\n<link href='http://resthtml.neo4j.org/style/rest.css' rel='stylesheet' type='text/css'>\n</head>\n<body onload='javascript:neo4jHtmlBrowse.start();' id='" + title.toLowerCase() + "'>\n<div id='content'><div id='header'><h1><a title='ONgDB REST interface' href='/'><span>ONgDB REST interface</span></a></h1></div>\n<div id='page-body'>\n");
        return builder;
    }

    public static String end(StringBuilder builder) {
        builder.append("<div class='break'>&nbsp;</div></div></div></body></html>");
        return builder.toString();
    }

    public static void appendMessage(StringBuilder builder, String message) {
        builder.append("<p class=\"message\">" + message + "</p>");
    }

    public static void append(StringBuilder builder, Object object, ObjectType objectType) {
        if (object instanceof Collection) {
            builder.append("<ul>\n");
            for (Object item : (Collection)object) {
                builder.append("<li>");
                HtmlHelper.append(builder, item, objectType);
                builder.append("</li>\n");
            }
            builder.append("</ul>\n");
        } else if (object instanceof Map) {
            Map map = (Map)object;
            String htmlClass = objectType.getHtmlClass();
            String caption = objectType.getCaption();
            if (!map.isEmpty()) {
                boolean isNodeOrRelationship;
                boolean bl = isNodeOrRelationship = ObjectType.NODE.equals((Object)objectType) || ObjectType.RELATIONSHIP.equals((Object)objectType);
                if (isNodeOrRelationship) {
                    builder.append("<h2>" + caption + "</h2>\n");
                    HtmlHelper.append(builder, map.get("data"), ObjectType.PROPERTIES);
                    htmlClass = "meta";
                    caption = caption + " info";
                }
                if (ObjectType.NODE.equals((Object)objectType) && map.size() == 1) {
                    return;
                }
                builder.append("<table class=\"" + htmlClass + "\"><caption>");
                builder.append(caption);
                builder.append("</caption>\n");
                boolean odd = true;
                for (Map.Entry entry : map.entrySet()) {
                    if (isNodeOrRelationship && "data".equals(entry.getKey())) continue;
                    builder.append("<tr" + (odd ? " class='odd'" : "") + ">");
                    odd = !odd;
                    builder.append("<th>" + entry.getKey() + "</th><td>");
                    HtmlHelper.append(builder, entry.getValue(), ObjectType.PROPERTIES);
                    builder.append("</td></tr>\n");
                }
                builder.append("</table>\n");
            } else {
                builder.append("<table class=\"" + htmlClass + "\"><caption>");
                builder.append(caption);
                builder.append("</caption>");
                builder.append("<tr><td></td></tr>");
                builder.append("</table>");
            }
        } else {
            builder.append(object != null ? HtmlHelper.embedInLinkIfClickable(object.toString()) : "");
        }
    }

    private static String embedInLinkIfClickable(String string) {
        if (string.startsWith("http://") || string.startsWith("https://")) {
            String anchoredString = "<a href=\"" + string + "\"";
            String anchorClass = null;
            if (string.contains("/node/")) {
                anchorClass = "node";
            } else if (string.contains("/relationship/")) {
                anchorClass = "relationship";
            }
            if (anchorClass != null) {
                anchoredString = anchoredString + " class=\"" + anchorClass + "\"";
            }
            string = anchoredString = anchoredString + ">" + HtmlHelper.escapeHtml(string) + "</a>";
        } else {
            string = HtmlHelper.escapeHtml(string);
        }
        return string;
    }

    private static String escapeHtml(String string) {
        if (string == null) {
            return null;
        }
        String res = string.replace("&", "&amp;");
        res = res.replace("\"", "&quot;");
        res = res.replace("<", "&lt;");
        res = res.replace(">", "&gt;");
        return res;
    }

    public static enum ObjectType {
        NODE,
        RELATIONSHIP,
        PROPERTIES,
        ROOT,
        INDEX_ROOT;


        String getCaption() {
            return this.name().substring(0, 1).toUpperCase() + this.name().substring(1).toLowerCase();
        }

        String getHtmlClass() {
            return this.getCaption().toLowerCase();
        }
    }
}

