/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.explicit;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.index.impl.lucene.explicit.IndexIdentifier;
import org.neo4j.index.impl.lucene.explicit.IndexType;
import org.neo4j.internal.kernel.api.exceptions.explicitindex.ExplicitIndexNotFoundKernelException;
import org.neo4j.kernel.impl.index.IndexConfigStore;

class IndexTypeCache {
    private final Map<IndexIdentifier, Pair<Integer, IndexType>> cache = Collections.synchronizedMap(new HashMap());
    private final IndexConfigStore indexStore;

    IndexTypeCache(IndexConfigStore indexStore) {
        this.indexStore = indexStore;
    }

    IndexType getIndexType(IndexIdentifier identifier, boolean recovery) throws ExplicitIndexNotFoundKernelException {
        Pair type = this.cache.get(identifier);
        Map config = this.indexStore.get(identifier.entityType.entityClass(), identifier.indexName);
        if (config == null) {
            if (recovery) {
                return null;
            }
            throw new ExplicitIndexNotFoundKernelException("Index '%s' doesn't exist.", new Object[]{identifier});
        }
        if (type != null && config.hashCode() == ((Integer)type.first()).intValue()) {
            return (IndexType)type.other();
        }
        type = Pair.of((Object)config.hashCode(), (Object)IndexType.getIndexType(config));
        this.cache.put(identifier, (Pair<Integer, IndexType>)type);
        return (IndexType)type.other();
    }

    void invalidate(IndexIdentifier identifier) {
        this.cache.remove(identifier);
    }
}

