/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.Comparator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.VirtualValue;
import org.neo4j.values.virtual.VirtualValueGroup;

public abstract class VirtualNodeValue
extends VirtualValue {
    public abstract long id();

    @Override
    public int compareTo(VirtualValue other2, Comparator<AnyValue> comparator2) {
        if (!(other2 instanceof VirtualNodeValue)) {
            throw new IllegalArgumentException("Cannot compare different virtual values");
        }
        VirtualNodeValue otherNode = (VirtualNodeValue)other2;
        return Long.compare(this.id(), otherNode.id());
    }

    @Override
    public int computeHash() {
        return Long.hashCode(this.id());
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapNode(this);
    }

    @Override
    public boolean equals(VirtualValue other2) {
        if (!(other2 instanceof VirtualNodeValue)) {
            return false;
        }
        VirtualNodeValue that = (VirtualNodeValue)other2;
        return this.id() == that.id();
    }

    @Override
    public VirtualValueGroup valueGroup() {
        return VirtualValueGroup.NODE;
    }
}

