/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.neo4j.unsafe.impl.batchimport.cache.ByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.HeapNumberArray;

public class HeapByteArray
extends HeapNumberArray<ByteArray>
implements ByteArray {
    private final int length;
    private final byte[] array;
    private final ByteBuffer buffer;
    private final byte[] defaultValue;
    private final boolean defaultValueIsUniform;

    public HeapByteArray(int length2, byte[] defaultValue, long base) {
        super(defaultValue.length, base);
        this.length = length2;
        this.defaultValue = defaultValue;
        this.array = new byte[this.itemSize * length2];
        this.buffer = ByteBuffer.wrap(this.array);
        this.defaultValueIsUniform = HeapByteArray.isUniform(defaultValue);
        this.clear();
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public void swap(long fromIndex, long toIndex) {
        for (int i = 0; i < this.itemSize; ++i) {
            int fromOffset = this.index(fromIndex, i);
            int toOffset = this.index(toIndex, i);
            byte intermediary = this.array[fromOffset];
            this.array[fromOffset] = this.array[toOffset];
            this.array[toOffset] = intermediary;
        }
    }

    @Override
    public void clear() {
        if (this.defaultValueIsUniform) {
            Arrays.fill(this.array, this.defaultValue[0]);
        } else {
            for (int i = 0; i < this.length; ++i) {
                System.arraycopy(this.defaultValue, 0, this.array, i * this.itemSize, this.itemSize);
            }
        }
    }

    private static boolean isUniform(byte[] value2) {
        byte reference = value2[0];
        for (int i = 1; i < value2.length; ++i) {
            if (reference == value2[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void get(long index, byte[] into) {
        System.arraycopy(this.array, this.index(index, 0), into, 0, this.itemSize);
    }

    @Override
    public byte getByte(long index, int offset) {
        return this.buffer.get(this.index(index, offset));
    }

    @Override
    public short getShort(long index, int offset) {
        return this.buffer.getShort(this.index(index, offset));
    }

    @Override
    public int getInt(long index, int offset) {
        return this.buffer.getInt(this.index(index, offset));
    }

    @Override
    public int get3ByteInt(long index, int offset) {
        int address = this.index(index, offset);
        return HeapByteArray.get3ByteIntFromByteBuffer(this.buffer, address);
    }

    @Override
    public long get5ByteLong(long index, int offset) {
        return HeapByteArray.get5BLongFromByteBuffer(this.buffer, this.index(index, offset));
    }

    @Override
    public long get6ByteLong(long index, int offset) {
        return HeapByteArray.get6BLongFromByteBuffer(this.buffer, this.index(index, offset));
    }

    protected static int get3ByteIntFromByteBuffer(ByteBuffer buffer, int address) {
        int highByte;
        int lowWord = buffer.getShort(address) & 0xFFFF;
        int result2 = lowWord | (highByte = buffer.get(address + 2) & 0xFF) << 16;
        return result2 == 0xFFFFFF ? -1 : result2;
    }

    protected static long get5BLongFromByteBuffer(ByteBuffer buffer, int startOffset) {
        long high1b;
        long low4b = (long)buffer.getInt(startOffset) & 0xFFFFFFFFL;
        long result2 = low4b | (high1b = (long)(buffer.get(startOffset + 4) & 0xFF)) << 32;
        return result2 == 0xFFFFFFFFFFL ? -1L : result2;
    }

    protected static long get6BLongFromByteBuffer(ByteBuffer buffer, int startOffset) {
        long high2b;
        long low4b = (long)buffer.getInt(startOffset) & 0xFFFFFFFFL;
        long result2 = low4b | (high2b = (long)(buffer.getShort(startOffset + 4) & 0xFFFF)) << 32;
        return result2 == 0xFFFFFFFFFFFFL ? -1L : result2;
    }

    @Override
    public long getLong(long index, int offset) {
        return this.buffer.getLong(this.index(index, offset));
    }

    @Override
    public void set(long index, byte[] value2) {
        System.arraycopy(value2, 0, this.array, this.index(index, 0), this.itemSize);
    }

    @Override
    public void setByte(long index, int offset, byte value2) {
        this.buffer.put(this.index(index, offset), value2);
    }

    @Override
    public void setShort(long index, int offset, short value2) {
        this.buffer.putShort(this.index(index, offset), value2);
    }

    @Override
    public void setInt(long index, int offset, int value2) {
        this.buffer.putInt(this.index(index, offset), value2);
    }

    @Override
    public void set5ByteLong(long index, int offset, long value2) {
        int absIndex = this.index(index, offset);
        this.buffer.putInt(absIndex, (int)value2);
        this.buffer.put(absIndex + 4, (byte)(value2 >>> 32));
    }

    @Override
    public void set6ByteLong(long index, int offset, long value2) {
        int absIndex = this.index(index, offset);
        this.buffer.putInt(absIndex, (int)value2);
        this.buffer.putShort(absIndex + 4, (short)(value2 >>> 32));
    }

    @Override
    public void setLong(long index, int offset, long value2) {
        this.buffer.putLong(this.index(index, offset), value2);
    }

    @Override
    public void set3ByteInt(long index, int offset, int value2) {
        int address = this.index(index, offset);
        this.buffer.putShort(address, (short)value2);
        this.buffer.put(address + 2, (byte)(value2 >>> 16));
    }

    private int index(long index, int offset) {
        return Math.toIntExact(this.rebase(index) * (long)this.itemSize + (long)offset);
    }
}

