/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.kernel.impl.util.collection.OffHeapBlockAllocator;
import org.neo4j.memory.MemoryAllocationTracker;
import org.neo4j.util.Preconditions;

public class CapacityLimitingBlockAllocatorDecorator
implements OffHeapBlockAllocator {
    private final OffHeapBlockAllocator impl;
    private final long maxMemory;
    private final AtomicLong usedMemory = new AtomicLong();

    public CapacityLimitingBlockAllocatorDecorator(OffHeapBlockAllocator impl, long maxMemory) {
        this.impl = Objects.requireNonNull(impl);
        this.maxMemory = Preconditions.requirePositive(maxMemory);
    }

    @Override
    public OffHeapBlockAllocator.MemoryBlock allocate(long size2, MemoryAllocationTracker tracker) {
        long usedMemoryAfter;
        long usedMemoryBefore;
        do {
            if ((usedMemoryAfter = (usedMemoryBefore = this.usedMemory.get()) + size2) <= this.maxMemory) continue;
            throw new RuntimeException(String.format("Can't allocate %d bytes due to exceeding memory limit; used=%d, max=%d", size2, usedMemoryBefore, this.maxMemory));
        } while (!this.usedMemory.compareAndSet(usedMemoryBefore, usedMemoryAfter));
        try {
            return this.impl.allocate(size2, tracker);
        }
        catch (Throwable t) {
            this.usedMemory.addAndGet(-size2);
            throw t;
        }
    }

    @Override
    public void free(OffHeapBlockAllocator.MemoryBlock block, MemoryAllocationTracker tracker) {
        try {
            this.impl.free(block, tracker);
        }
        finally {
            this.usedMemory.addAndGet(-block.size);
        }
    }

    @Override
    public void release() {
        try {
            this.impl.release();
        }
        finally {
            this.usedMemory.set(0L);
        }
    }
}

