/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.reverse;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.ReadAheadChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.UnsupportedLogVersionException;
import org.neo4j.kernel.impl.transaction.log.reverse.ReversedTransactionCursorMonitor;

public class ReversedSingleFileTransactionCursor
implements TransactionCursor {
    private static final int CHUNK_SIZE = ReadAheadChannel.DEFAULT_READ_AHEAD_SIZE;
    private final ReadAheadLogChannel channel;
    private final boolean failOnCorruptedLogFiles;
    private final ReversedTransactionCursorMonitor monitor;
    private final TransactionCursor transactionCursor;
    private final Deque<CommittedTransactionRepresentation> chunkTransactions = new ArrayDeque<CommittedTransactionRepresentation>(20);
    private CommittedTransactionRepresentation currentChunkTransaction;
    private final long[] offsets;
    private int offsetsLength;
    private int chunkStartOffsetIndex;
    private long totalSize;

    ReversedSingleFileTransactionCursor(ReadAheadLogChannel channel, LogEntryReader<ReadableClosablePositionAwareChannel> logEntryReader, boolean failOnCorruptedLogFiles, ReversedTransactionCursorMonitor monitor) throws IOException {
        this.channel = channel;
        this.failOnCorruptedLogFiles = failOnCorruptedLogFiles;
        this.monitor = monitor;
        this.transactionCursor = new PhysicalTransactionCursor<ReadableClosablePositionAwareChannel>(channel, logEntryReader);
        this.offsets = this.sketchOutTransactionStartOffsets();
    }

    private long[] sketchOutTransactionStartOffsets() throws IOException {
        long logVersion;
        int offsetCursor;
        long[] offsets;
        block5: {
            offsets = new long[10000];
            offsetCursor = 0;
            logVersion = this.channel.getVersion();
            long startOffset = this.channel.position();
            try {
                while (this.transactionCursor.next()) {
                    if (offsetCursor == offsets.length) {
                        offsets = Arrays.copyOf(offsets, offsetCursor * 2);
                    }
                    offsets[offsetCursor++] = startOffset;
                    startOffset = this.channel.position();
                }
            }
            catch (IOException | UnsupportedLogVersionException e) {
                this.monitor.transactionalLogRecordReadFailure(offsets, offsetCursor, logVersion);
                if (!this.failOnCorruptedLogFiles) break block5;
                throw e;
            }
        }
        if (this.channel.getVersion() != logVersion) {
            throw new IllegalArgumentException("The channel which was passed in bridged multiple log versions, it started at version " + logVersion + ", but continued through to version " + this.channel.getVersion() + ". This isn't supported");
        }
        this.offsetsLength = offsetCursor;
        this.chunkStartOffsetIndex = offsetCursor;
        this.totalSize = this.channel.position();
        return offsets;
    }

    @Override
    public boolean next() throws IOException {
        if (!this.exhausted()) {
            if (this.currentChunkExhausted()) {
                this.readNextChunk();
            }
            this.currentChunkTransaction = this.chunkTransactions.pop();
            return true;
        }
        return false;
    }

    private void readNextChunk() throws IOException {
        long deltaOffset;
        assert (this.chunkStartOffsetIndex > 0);
        long highOffset = this.chunkStartOffsetIndex == this.offsetsLength ? this.totalSize : this.offsets[this.chunkStartOffsetIndex];
        int newLowOffsetIndex = this.chunkStartOffsetIndex;
        while (newLowOffsetIndex > 0 && (deltaOffset = highOffset - this.offsets[--newLowOffsetIndex]) <= (long)CHUNK_SIZE) {
        }
        assert (this.chunkStartOffsetIndex - newLowOffsetIndex > 0);
        int chunkLength = this.chunkStartOffsetIndex - newLowOffsetIndex;
        this.chunkStartOffsetIndex = newLowOffsetIndex;
        this.channel.setCurrentPosition(this.offsets[this.chunkStartOffsetIndex]);
        assert (this.chunkTransactions.isEmpty());
        for (int i = 0; i < chunkLength; ++i) {
            boolean success = this.transactionCursor.next();
            assert (success);
            this.chunkTransactions.push((CommittedTransactionRepresentation)this.transactionCursor.get());
        }
    }

    private boolean currentChunkExhausted() {
        return this.chunkTransactions.isEmpty();
    }

    private boolean exhausted() {
        return this.chunkStartOffsetIndex == 0 && this.currentChunkExhausted();
    }

    @Override
    public void close() throws IOException {
        this.transactionCursor.close();
    }

    @Override
    public CommittedTransactionRepresentation get() {
        return this.currentChunkTransaction;
    }

    @Override
    public LogPosition position() {
        throw new UnsupportedOperationException("Should not be called");
    }
}

