/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;

public class ReadOnlyTransactionStore
implements Lifecycle,
LogicalTransactionStore {
    private final LifeSupport life = new LifeSupport();
    private final LogicalTransactionStore physicalStore;

    public ReadOnlyTransactionStore(PageCache pageCache, FileSystemAbstraction fs, DatabaseLayout fromDatabaseLayout, Config config, Monitors monitors) throws IOException {
        TransactionMetadataCache transactionMetadataCache = new TransactionMetadataCache();
        VersionAwareLogEntryReader<ReadableClosablePositionAwareChannel> logEntryReader = new VersionAwareLogEntryReader<ReadableClosablePositionAwareChannel>();
        LogFiles logFiles = LogFilesBuilder.activeFilesBuilder(fromDatabaseLayout, fs, pageCache).withLogEntryReader(logEntryReader).withConfig(config).build();
        this.physicalStore = new PhysicalLogicalTransactionStore(logFiles, transactionMetadataCache, logEntryReader, monitors, true);
    }

    @Override
    public TransactionCursor getTransactions(long transactionIdToStartFrom) throws IOException {
        return this.physicalStore.getTransactions(transactionIdToStartFrom);
    }

    @Override
    public TransactionCursor getTransactions(LogPosition position2) throws IOException {
        return this.physicalStore.getTransactions(position2);
    }

    @Override
    public TransactionCursor getTransactionsInReverseOrder(LogPosition backToPosition) throws IOException {
        return this.physicalStore.getTransactionsInReverseOrder(backToPosition);
    }

    @Override
    public TransactionMetadataCache.TransactionMetadata getMetadataFor(long transactionId) throws IOException {
        return this.physicalStore.getMetadataFor(transactionId);
    }

    @Override
    public boolean existsOnDisk(long transactionId) throws IOException {
        return this.physicalStore.existsOnDisk(transactionId);
    }

    @Override
    public void init() {
        this.life.init();
    }

    @Override
    public void start() {
        this.life.start();
    }

    @Override
    public void stop() {
        this.life.stop();
    }

    @Override
    public void shutdown() {
        this.life.shutdown();
    }
}

