/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.monitoring;

import java.time.Clock;
import org.neo4j.helpers.Format;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;
import org.neo4j.kernel.impl.util.monitoring.LogProgressReporter;
import org.neo4j.kernel.impl.util.monitoring.ProgressReporter;
import org.neo4j.logging.Log;

public class VisibleMigrationProgressMonitor
implements MigrationProgressMonitor {
    static final String MESSAGE_STARTED = "Starting upgrade of database";
    static final String MESSAGE_COMPLETED = "Successfully finished upgrade of database";
    private static final String MESSAGE_COMPLETED_WITH_DURATION = "Successfully finished upgrade of database, took %s";
    private final Log log;
    private final Clock clock;
    private int numStages;
    private int currentStage;
    private long startTime;

    public VisibleMigrationProgressMonitor(Log log) {
        this(log, Clock.systemUTC());
    }

    VisibleMigrationProgressMonitor(Log log, Clock clock) {
        this.log = log;
        this.clock = clock;
    }

    @Override
    public void started(int numStages) {
        this.numStages = numStages;
        this.log.info(MESSAGE_STARTED);
        this.startTime = this.clock.millis();
    }

    @Override
    public ProgressReporter startSection(String name) {
        this.log.info(String.format("Migrating %s (%d/%d):", name, ++this.currentStage, this.numStages));
        return new LogProgressReporter(this.log);
    }

    @Override
    public void completed() {
        long time = this.clock.millis() - this.startTime;
        this.log.info(MESSAGE_COMPLETED_WITH_DURATION, new Object[]{Format.duration(time)});
    }
}

