/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.neo4j.kernel.impl.store.kvstore.AbstractKeyValueStore;
import org.neo4j.kernel.impl.store.kvstore.UpdateLock;
import org.neo4j.logging.Logger;
import org.neo4j.util.FeatureToggles;

public class LockWrapper
implements AutoCloseable {
    private static final boolean debugLocking = FeatureToggles.flag(AbstractKeyValueStore.class, "debugLocking", false);
    private Lock lock;

    public static LockWrapper readLock(UpdateLock lock, Logger logger) {
        return new LockWrapper(lock.readLock(), lock, logger);
    }

    public static LockWrapper writeLock(UpdateLock lock, Logger logger) {
        return new LockWrapper(lock.writeLock(), lock, logger);
    }

    private LockWrapper(Lock lock, UpdateLock managingLock, Logger logger) {
        this.lock = lock;
        if (debugLocking) {
            if (!lock.tryLock()) {
                logger.log(Thread.currentThread() + " may block on " + lock + " of " + managingLock);
                while (!LockWrapper.tryLockBlocking(lock, managingLock, logger)) {
                    logger.log(Thread.currentThread() + " still blocked on " + lock + " of " + managingLock);
                }
            }
        } else {
            lock.lock();
        }
    }

    private static boolean tryLockBlocking(Lock lock, UpdateLock managingLock, Logger logger) {
        try {
            return lock.tryLock(1L, TimeUnit.HOURS);
        }
        catch (InterruptedException e) {
            logger.log(Thread.currentThread() + " ignoring interrupt while blocked on " + lock + " of " + managingLock);
            return false;
        }
    }

    @Override
    public void close() {
        if (this.lock != null) {
            this.lock.unlock();
            this.lock = null;
        }
    }

    public Lock get() {
        return this.lock;
    }
}

