/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.neo4j.kernel.impl.store.kvstore.BigEndianByteArrayBuffer;
import org.neo4j.kernel.impl.store.kvstore.HeaderField;

public abstract class Headers {
    public abstract <Value> Value get(HeaderField<Value> var1);

    public static Builder headersBuilder() {
        return new Builder(new HashMap());
    }

    <Value> void write(HeaderField<Value> field2, BigEndianByteArrayBuffer target) {
        field2.write(this.get(field2), target);
    }

    public abstract Set<HeaderField<?>> fields();

    private Headers() {
    }

    static Headers indexedHeaders(Map<HeaderField<?>, Integer> indexes, Object[] values2) {
        return new Indexed(indexes, values2);
    }

    public final int hashCode() {
        int hash = 0;
        for (HeaderField<?> field2 : this.fields()) {
            hash ^= field2.hashCode();
        }
        return hash;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Headers) {
            Set<HeaderField<?>> those;
            Headers that = (Headers)obj;
            Set<HeaderField<?>> these = this.fields();
            if (((Object)these).equals(those = that.fields())) {
                for (HeaderField headerField : these) {
                    Object tat;
                    Object tis = this.get(headerField);
                    if (tis.equals(tat = that.get(headerField))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public final String toString() {
        StringBuilder result2 = new StringBuilder().append("Headers{");
        String pre = "";
        for (HeaderField<?> field2 : this.fields()) {
            result2.append(pre).append(field2).append(": ").append(this.get(field2));
            pre = ", ";
        }
        return result2.append("}").toString();
    }

    static Map<HeaderField<?>, Object> copy(Headers headers) {
        HashMap copy2 = new HashMap();
        for (HeaderField<?> field2 : headers.fields()) {
            copy2.put(field2, headers.get(field2));
        }
        return copy2;
    }

    private static class Simple
    extends Headers {
        private final Map<HeaderField<?>, Object> headers;

        Simple(Map<HeaderField<?>, Object> headers) {
            this.headers = headers;
        }

        @Override
        public <Value> Value get(HeaderField<Value> field2) {
            return (Value)this.headers.get(field2);
        }

        @Override
        public Set<HeaderField<?>> fields() {
            return this.headers.keySet();
        }
    }

    private static class Indexed
    extends Headers {
        private final Map<HeaderField<?>, Integer> indexes;
        private final Object[] values;

        Indexed(Map<HeaderField<?>, Integer> indexes, Object[] values2) {
            this.indexes = indexes;
            this.values = values2;
        }

        @Override
        public <Value> Value get(HeaderField<Value> field2) {
            Integer index = this.indexes.get(field2);
            return (Value)(index == null ? null : this.values[index]);
        }

        @Override
        public Set<HeaderField<?>> fields() {
            return this.indexes.keySet();
        }
    }

    public static class Builder {
        private final Map<HeaderField<?>, Object> headers;

        Builder(Map<HeaderField<?>, Object> headers) {
            this.headers = headers;
        }

        public final <Value> Builder put(HeaderField<Value> field2, Value value2) {
            this.headers.put(field2, value2);
            return this;
        }

        public final <Value> Value get(HeaderField<Value> field2) {
            return (Value)this.headers.get(field2);
        }

        public Headers headers() {
            return new Simple(new HashMap(this.headers));
        }
    }
}

