/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.store.kvstore.ReadableBuffer;
import org.neo4j.kernel.impl.store.kvstore.WritableBuffer;

public final class BigEndianByteArrayBuffer
implements ReadableBuffer,
WritableBuffer {
    final byte[] buffer;

    static BigEndianByteArrayBuffer newBuffer(int size2) {
        return new BigEndianByteArrayBuffer(size2);
    }

    BigEndianByteArrayBuffer(int size2) {
        this(new byte[size2]);
    }

    public BigEndianByteArrayBuffer(byte[] buffer) {
        this.buffer = buffer;
    }

    public String toString() {
        return BigEndianByteArrayBuffer.toString(this.buffer);
    }

    static String toString(byte[] buffer) {
        StringBuilder result2 = new StringBuilder(buffer.length * 6 + 1).append('[');
        for (byte b : buffer) {
            if (b >= 32 && b < 127) {
                if (b == 39) {
                    result2.append("'\\''");
                } else {
                    result2.append('\'').append((char)b).append('\'');
                }
            } else {
                result2.append("0x");
                if (b < 16) {
                    result2.append(0);
                }
                result2.append(Integer.toHexString(b & 0xFF));
            }
            result2.append(", ");
        }
        if (result2.length() > 1) {
            result2.setLength(result2.length() - 2);
        }
        result2.append(']');
        return result2.toString();
    }

    static int compare(byte[] key, byte[] searchSpace, int offset) {
        for (int i = 0; i < key.length; ++i) {
            int result2 = (key[i] & 0xFF) - (searchSpace[offset + i] & 0xFF);
            if (result2 == 0) continue;
            return result2;
        }
        return 0;
    }

    public void clear() {
        this.fill((byte)0);
    }

    public void fill(byte zero) {
        Arrays.fill(this.buffer, zero);
    }

    @Override
    public boolean allZeroes() {
        for (byte b : this.buffer) {
            if (b == 0) continue;
            return false;
        }
        return true;
    }

    public boolean minusOneAtTheEnd() {
        int i;
        for (i = 0; i < this.buffer.length / 2; ++i) {
            if (this.buffer[i] == 0) continue;
            return false;
        }
        for (i = this.buffer.length / 2; i < this.buffer.length; ++i) {
            if (this.buffer[i] == -1) continue;
            return false;
        }
        return true;
    }

    public void dataFrom(ByteBuffer buffer) {
        buffer.get(this.buffer);
    }

    public void dataTo(byte[] target, int targetPos) {
        assert (target.length >= targetPos + this.buffer.length) : "insufficient space";
        System.arraycopy(this.buffer, 0, target, targetPos, this.buffer.length);
    }

    @Override
    public int size() {
        return this.buffer.length;
    }

    @Override
    public byte getByte(int offset) {
        offset = this.checkBounds(offset, 1);
        return this.buffer[offset];
    }

    @Override
    public BigEndianByteArrayBuffer putByte(int offset, byte value2) {
        return this.putValue(offset, value2, 1);
    }

    @Override
    public short getShort(int offset) {
        offset = this.checkBounds(offset, 2);
        return (short)((0xFF & this.buffer[offset]) << 8 | 0xFF & this.buffer[offset + 1]);
    }

    @Override
    public BigEndianByteArrayBuffer putShort(int offset, short value2) {
        return this.putValue(offset, value2, 2);
    }

    @Override
    public char getChar(int offset) {
        offset = this.checkBounds(offset, 2);
        return (char)((0xFF & this.buffer[offset]) << 8 | 0xFF & this.buffer[offset + 1]);
    }

    @Override
    public BigEndianByteArrayBuffer putChar(int offset, char value2) {
        return this.putValue(offset, value2, 2);
    }

    @Override
    public int getInt(int offset) {
        offset = this.checkBounds(offset, 4);
        return (0xFF & this.buffer[offset]) << 24 | (0xFF & this.buffer[offset + 1]) << 16 | (0xFF & this.buffer[offset + 2]) << 8 | 0xFF & this.buffer[offset + 3];
    }

    @Override
    public BigEndianByteArrayBuffer putInt(int offset, int value2) {
        return this.putValue(offset, value2, 4);
    }

    @Override
    public long getLong(int offset) {
        offset = this.checkBounds(offset, 8);
        return (0xFFL & (long)this.buffer[offset]) << 56 | (0xFFL & (long)this.buffer[offset + 1]) << 48 | (0xFFL & (long)this.buffer[offset + 2]) << 40 | (0xFFL & (long)this.buffer[offset + 3]) << 32 | (0xFFL & (long)this.buffer[offset + 4]) << 24 | (0xFFL & (long)this.buffer[offset + 5]) << 16 | (0xFFL & (long)this.buffer[offset + 6]) << 8 | 0xFFL & (long)this.buffer[offset + 7];
    }

    @Override
    public byte[] get(int offset, byte[] target) {
        System.arraycopy(this.buffer, offset, target, 0, target.length);
        return target;
    }

    @Override
    public int compareTo(byte[] value2) {
        return BigEndianByteArrayBuffer.compare(this.buffer, value2, 0);
    }

    @Override
    public BigEndianByteArrayBuffer putLong(int offset, long value2) {
        return this.putValue(offset, value2, 8);
    }

    @Override
    public BigEndianByteArrayBuffer put(int offset, byte[] value2) {
        System.arraycopy(value2, 0, this.buffer, offset, value2.length);
        return this;
    }

    @Override
    public void getFrom(PageCursor cursor) {
        cursor.getBytes(this.buffer);
    }

    private BigEndianByteArrayBuffer putValue(int offset, long value2, int size2) {
        offset = this.checkBounds(offset, size2);
        while (size2-- > 0) {
            this.buffer[offset + size2] = (byte)(0xFFL & value2);
            value2 >>>= 8;
        }
        return this;
    }

    void putIntegerAtEnd(long value2) throws IOException {
        if (value2 < -1L) {
            throw new IllegalArgumentException("Negative values different form -1 are not supported.");
        }
        if (this.size() < 8 && Long.numberOfLeadingZeros(value2) > 8 * this.size()) {
            throw new IOException(String.format("Cannot write integer value (%d), value capacity = %d", value2, this.size()));
        }
        int i = this.buffer.length;
        while (i-- > 0 && value2 != 0L) {
            this.buffer[i] = (byte)(0xFFL & value2);
            value2 >>>= 8;
        }
    }

    long getIntegerFromEnd() {
        long value2 = 0L;
        for (int i = Math.max(0, this.buffer.length - 8); i < this.buffer.length; ++i) {
            value2 = value2 << 8 | 0xFFL & (long)this.buffer[i];
        }
        return value2;
    }

    public void read(WritableBuffer target) {
        target.put(0, this.buffer);
    }

    private int checkBounds(int offset, int size2) {
        if (offset < 0 || offset > this.size() - size2) {
            throw new IndexOutOfBoundsException(String.format("offset=%d, buffer size=%d, data item size=%d", offset, this.size(), size2));
        }
        return offset;
    }
}

