/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id;

import java.util.function.LongConsumer;
import org.neo4j.graphdb.Resource;
import org.neo4j.kernel.impl.store.id.IdRange;
import org.neo4j.kernel.impl.store.id.IdSequence;

public class RenewableBatchIdSequence
implements IdSequence,
Resource {
    private final IdSequence source;
    private final int batchSize;
    private final LongConsumer excessIdConsumer;
    private IdSequence currentBatch;
    private boolean closed;

    RenewableBatchIdSequence(IdSequence source, int batchSize, LongConsumer excessIdConsumer) {
        this.source = source;
        this.batchSize = batchSize;
        this.excessIdConsumer = excessIdConsumer;
    }

    public synchronized void close() {
        if (!this.closed && this.currentBatch != null) {
            long id2;
            while ((id2 = this.currentBatch.nextId()) != -1L) {
                this.excessIdConsumer.accept(id2);
            }
            this.currentBatch = null;
        }
        this.closed = true;
    }

    @Override
    public long nextId() {
        long id2;
        assert (!this.closed);
        while (this.currentBatch == null || (id2 = this.currentBatch.nextId()) == -1L) {
            this.currentBatch = this.source.nextIdBatch(this.batchSize).iterator();
        }
        return id2;
    }

    @Override
    public IdRange nextIdBatch(int size2) {
        throw new UnsupportedOperationException("Haven't been needed so far");
    }
}

