/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.nio.file.OpenOption;
import java.util.Arrays;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.NoStoreHeader;
import org.neo4j.kernel.impl.store.NoStoreHeaderFormat;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.util.Bits;
import org.neo4j.logging.LogProvider;

public class NodeStore
extends CommonAbstractStore<NodeRecord, NoStoreHeader> {
    public static final String TYPE_DESCRIPTOR = "NodeStore";
    private final DynamicArrayStore dynamicLabelStore;

    public static Long readOwnerFromDynamicLabelsRecord(DynamicRecord record) {
        byte[] data = record.getData();
        byte[] header = PropertyType.ARRAY.readDynamicRecordHeader(data);
        byte[] array = Arrays.copyOfRange(data, header.length, data.length);
        byte requiredBits = header[2];
        if (requiredBits == 0) {
            return null;
        }
        Bits bits2 = Bits.bitsFromBytes(array);
        return bits2.getLong(requiredBits);
    }

    public NodeStore(File file, File idFile, Config config, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, LogProvider logProvider, DynamicArrayStore dynamicLabelStore, RecordFormats recordFormats, OpenOption ... openOptions) {
        super(file, idFile, config, IdType.NODE, idGeneratorFactory, pageCache, logProvider, TYPE_DESCRIPTOR, recordFormats.node(), NoStoreHeaderFormat.NO_STORE_HEADER_FORMAT, recordFormats.storeVersion(), openOptions);
        this.dynamicLabelStore = dynamicLabelStore;
    }

    @Override
    public <FAILURE extends Exception> void accept(RecordStore.Processor<FAILURE> processor, NodeRecord record) throws FAILURE {
        processor.processNode(this, record);
    }

    @Override
    public void ensureHeavy(NodeRecord node) {
        if (NodeLabelsField.fieldPointsToDynamicRecordOfLabels(node.getLabelField())) {
            this.ensureHeavy(node, NodeLabelsField.firstDynamicLabelRecordId(node.getLabelField()));
        }
    }

    public void ensureHeavy(NodeRecord node, long firstDynamicLabelRecord) {
        if (!node.isLight()) {
            return;
        }
        node.setLabelField(node.getLabelField(), this.dynamicLabelStore.getRecords(firstDynamicLabelRecord, RecordLoad.NORMAL));
    }

    @Override
    public void updateRecord(NodeRecord record) {
        super.updateRecord(record);
        this.updateDynamicLabelRecords(record.getDynamicLabelRecords());
    }

    public DynamicArrayStore getDynamicLabelStore() {
        return this.dynamicLabelStore;
    }

    public void updateDynamicLabelRecords(Iterable<DynamicRecord> dynamicLabelRecords) {
        for (DynamicRecord record : dynamicLabelRecords) {
            this.dynamicLabelStore.updateRecord(record);
        }
    }
}

