/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import org.apache.commons.lang3.exception.CloneFailedException;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.newapi.References;
import org.neo4j.kernel.impl.newapi.RelationshipReferenceEncoding;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.GroupReferenceEncoding;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordRelationshipTraversalCursor;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.storageengine.api.StorageRelationshipGroupCursor;

class RecordRelationshipGroupCursor
extends RelationshipGroupRecord
implements StorageRelationshipGroupCursor {
    private final RelationshipStore relationshipStore;
    private final RelationshipGroupStore groupStore;
    private final RelationshipRecord edge = new RelationshipRecord(-1L);
    private BufferedGroup bufferedGroup;
    private PageCursor page;
    private PageCursor edgePage;
    private boolean open;

    RecordRelationshipGroupCursor(RelationshipStore relationshipStore, RelationshipGroupStore groupStore) {
        super(-1L);
        this.relationshipStore = relationshipStore;
        this.groupStore = groupStore;
    }

    public void init(long nodeReference, long reference) {
        if (reference != -1L && GroupReferenceEncoding.isRelationship(reference)) {
            this.buffer(nodeReference, References.clearEncoding(reference));
        } else {
            this.direct(nodeReference, reference);
        }
        this.open = true;
    }

    private void buffer(long nodeReference, long relationshipReference) {
        this.setOwningNode(nodeReference);
        this.setId(-1L);
        this.setNext(-1L);
        try (PageCursor edgePage = this.relationshipStore.openPageCursorForReading(relationshipReference);){
            IntObjectHashMap buffer = new IntObjectHashMap();
            BufferedGroup current = null;
            while (relationshipReference != -1L) {
                this.relationshipStore.getRecordByCursor(relationshipReference, this.edge, RecordLoad.FORCE, edgePage);
                BufferedGroup group = (BufferedGroup)buffer.get(this.edge.getType());
                if (group == null) {
                    current = group = new BufferedGroup(this.edge, current);
                    buffer.put(this.edge.getType(), (Object)group);
                }
                if (this.edge.getFirstNode() == nodeReference) {
                    if (this.edge.getSecondNode() == nodeReference) {
                        group.loop(this.edge);
                    } else {
                        group.outgoing(this.edge);
                    }
                    relationshipReference = this.edge.getFirstNextRel();
                    continue;
                }
                if (this.edge.getSecondNode() == nodeReference) {
                    group.incoming(this.edge);
                    relationshipReference = this.edge.getSecondNextRel();
                    continue;
                }
                throw new IllegalStateException("not a part of the chain! TODO: better exception");
            }
            this.bufferedGroup = new BufferedGroup(this.edge, current);
        }
    }

    void direct(long nodeReference, long reference) {
        this.bufferedGroup = null;
        this.clear();
        this.setOwningNode(nodeReference);
        this.setNext(reference);
        if (this.page == null) {
            this.page = this.groupPage(reference);
        }
    }

    public boolean next() {
        if (this.isBuffered()) {
            this.bufferedGroup = this.bufferedGroup.next;
            if (this.bufferedGroup != null) {
                this.loadFromBuffer();
                return true;
            }
        }
        do {
            if (this.getNext() == -1L) {
                return false;
            }
            this.group(this, this.getNext(), this.page);
        } while (!this.inUse());
        return true;
    }

    public void setCurrent(int groupReference, int firstOut, int firstIn, int firstLoop) {
        this.setType(groupReference);
        this.setFirstOut(firstOut);
        this.setFirstIn(firstIn);
        this.setFirstLoop(firstLoop);
    }

    private void loadFromBuffer() {
        this.setType(this.bufferedGroup.label);
        this.setFirstOut(this.bufferedGroup.outgoing());
        this.setFirstIn(this.bufferedGroup.incoming());
        this.setFirstLoop(this.bufferedGroup.loops());
    }

    public void reset() {
        if (this.open) {
            this.open = false;
            this.bufferedGroup = null;
            this.setId(-1L);
            this.clear();
        }
    }

    public int type() {
        return this.getType();
    }

    public int outgoingCount() {
        return this.isBuffered() ? this.bufferedGroup.outgoingCount : this.count(this.outgoingRawId());
    }

    public int incomingCount() {
        return this.isBuffered() ? this.bufferedGroup.incomingCount : this.count(this.incomingRawId());
    }

    public int loopCount() {
        return this.isBuffered() ? this.bufferedGroup.loopsCount : this.count(this.loopsRawId());
    }

    private int count(long reference) {
        if (reference == -1L) {
            return 0;
        }
        if (this.edgePage == null) {
            this.edgePage = this.relationshipStore.openPageCursorForReading(reference);
        }
        this.relationshipStore.getRecordByCursor(reference, this.edge, RecordLoad.FORCE, this.edgePage);
        if (this.edge.getFirstNode() == this.getOwningNode()) {
            return (int)this.edge.getFirstPrevRel();
        }
        return (int)this.edge.getSecondPrevRel();
    }

    public long outgoingReference() {
        long outgoing = this.getFirstOut();
        return outgoing == -1L ? -1L : this.encodeRelationshipReference(outgoing);
    }

    public long incomingReference() {
        long incoming = this.getFirstIn();
        return incoming == -1L ? -1L : this.encodeRelationshipReference(incoming);
    }

    public long loopsReference() {
        long loops = this.getFirstLoop();
        return loops == -1L ? -1L : this.encodeRelationshipReference(loops);
    }

    @Override
    public RelationshipGroupRecord clone() {
        throw new CloneFailedException("Record cursors are not cloneable.");
    }

    @Override
    public String toString() {
        if (!this.open) {
            return "RelationshipGroupCursor[closed state]";
        }
        String mode = "mode=";
        mode = this.isBuffered() ? mode + "group" : mode + "direct";
        return "RelationshipGroupCursor[id=" + this.getId() + ", open state with: " + mode + ", underlying record=" + super.toString() + "]";
    }

    long outgoingRawId() {
        return this.getFirstOut();
    }

    long incomingRawId() {
        return this.getFirstIn();
    }

    long loopsRawId() {
        return this.getFirstLoop();
    }

    private long encodeRelationshipReference(long relationshipId) {
        assert (relationshipId != -1L);
        return this.isBuffered() ? RelationshipReferenceEncoding.encodeForFiltering(relationshipId) : RelationshipReferenceEncoding.encodeForTxStateFiltering(relationshipId);
    }

    private boolean isBuffered() {
        return this.bufferedGroup != null;
    }

    public void close() {
        if (this.edgePage != null) {
            this.edgePage.close();
            this.edgePage = null;
        }
        if (this.page != null) {
            this.page.close();
            this.page = null;
        }
    }

    public long groupReference() {
        return this.getId();
    }

    private PageCursor groupPage(long reference) {
        return this.groupStore.openPageCursorForReading(reference);
    }

    private void group(RelationshipGroupRecord record, long reference, PageCursor page) {
        this.groupStore.getRecordByCursor(reference, record, RecordLoad.FORCE, page);
    }

    static class BufferedGroup {
        final int label;
        final BufferedGroup next;
        RecordRelationshipTraversalCursor.Record outgoing;
        RecordRelationshipTraversalCursor.Record incoming;
        RecordRelationshipTraversalCursor.Record loops;
        private long firstOut = -1L;
        private long firstIn = -1L;
        private long firstLoop = -1L;
        int outgoingCount;
        int incomingCount;
        int loopsCount;

        BufferedGroup(RelationshipRecord edge, BufferedGroup next2) {
            this.label = edge.getType();
            this.next = next2;
        }

        void outgoing(RelationshipRecord edge) {
            if (this.outgoing == null) {
                this.firstOut = edge.getId();
            }
            this.outgoing = new RecordRelationshipTraversalCursor.Record(edge, this.outgoing);
            ++this.outgoingCount;
        }

        void incoming(RelationshipRecord edge) {
            if (this.incoming == null) {
                this.firstIn = edge.getId();
            }
            this.incoming = new RecordRelationshipTraversalCursor.Record(edge, this.incoming);
            ++this.incomingCount;
        }

        void loop(RelationshipRecord edge) {
            if (this.loops == null) {
                this.firstLoop = edge.getId();
            }
            this.loops = new RecordRelationshipTraversalCursor.Record(edge, this.loops);
            ++this.loopsCount;
        }

        long outgoing() {
            return this.firstOut;
        }

        long incoming() {
            return this.firstIn;
        }

        long loops() {
            return this.firstLoop;
        }
    }
}

