/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.impl.proc.ComponentRegistry;
import org.neo4j.procedure.ProcedureTransaction;

public class ProcedureTransactionProvider
implements ComponentRegistry.Provider<ProcedureTransaction> {
    @Override
    public ProcedureTransaction apply(Context ctx) throws ProcedureException {
        KernelTransaction ktx = ctx.get(Context.KERNEL_TRANSACTION);
        return new ProcedureTransactionImpl(ktx);
    }

    private static class ProcedureTransactionImpl
    implements ProcedureTransaction {
        private final KernelTransaction ktx;

        ProcedureTransactionImpl(KernelTransaction ktx) {
            this.ktx = ktx;
        }

        public void terminate() {
            this.ktx.markForTermination(Status.Transaction.Terminated);
        }

        public void failure() {
            this.ktx.failure();
        }
    }
}

