/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.Collection;
import org.neo4j.cursor.RawCursor;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.impl.index.schema.NativeHitIndexProgressor;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.values.storable.Value;

class FilteringNativeHitIndexProgressor<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
extends NativeHitIndexProgressor<KEY, VALUE> {
    private final IndexQuery[] filter;

    FilteringNativeHitIndexProgressor(RawCursor<Hit<KEY, VALUE>, IOException> seeker, IndexProgressor.NodeValueClient client, Collection<RawCursor<Hit<KEY, VALUE>, IOException>> toRemoveFromOnClose, IndexQuery[] filter2) {
        super(seeker, client, toRemoveFromOnClose);
        this.filter = filter2;
    }

    @Override
    protected boolean acceptValue(Value[] values2) {
        for (int i = 0; i < values2.length; ++i) {
            if (this.filter[i].acceptsValue(values2[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    Value[] extractValues(KEY key) {
        return ((NativeIndexKey)key).asValues();
    }
}

