/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.kernel.impl.index.schema.NativeIndexSingleValueKey;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

class DateIndexKey
extends NativeIndexSingleValueKey<DateIndexKey> {
    static final int SIZE = 16;
    long epochDay;

    DateIndexKey() {
    }

    @Override
    public Value asValue() {
        return DateValue.epochDate(this.epochDay);
    }

    @Override
    void initValueAsLowest(ValueGroup valueGroups) {
        this.epochDay = Long.MIN_VALUE;
    }

    @Override
    void initValueAsHighest(ValueGroup valueGroups) {
        this.epochDay = Long.MAX_VALUE;
    }

    @Override
    public int compareValueTo(DateIndexKey other2) {
        return Long.compare(this.epochDay, other2.epochDay);
    }

    public String toString() {
        return String.format("value=%s,entityId=%d,epochDay=%d", this.asValue(), this.getEntityId(), this.epochDay);
    }

    @Override
    public void writeDate(long epochDay) {
        this.epochDay = epochDay;
    }

    @Override
    protected Value assertCorrectType(Value value2) {
        if (!(value2 instanceof DateValue)) {
            throw new IllegalArgumentException("Key layout does only support DateValue, tried to create key from " + value2);
        }
        return value2;
    }
}

