/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import java.util.Map;
import java.util.Optional;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.graphdb.TransientFailureException;
import org.neo4j.graphdb.TransientTransactionFailureException;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.ConstraintViolationTransactionFailureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.PropertyContainerLocker;

public class TopLevelTransaction
implements InternalTransaction {
    private static final PropertyContainerLocker locker = new PropertyContainerLocker();
    private boolean successCalled;
    private final KernelTransaction transaction;

    public TopLevelTransaction(KernelTransaction transaction) {
        this.transaction = transaction;
    }

    @Override
    public void failure() {
        this.transaction.failure();
    }

    @Override
    public void success() {
        this.successCalled = true;
        this.transaction.success();
    }

    @Override
    public final void terminate() {
        this.transaction.markForTermination(Status.Transaction.Terminated);
    }

    @Override
    public void close() {
        try {
            if (this.transaction.isOpen()) {
                this.transaction.close();
            }
        }
        catch (TransientFailureException e) {
            throw e;
        }
        catch (ConstraintViolationTransactionFailureException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (TransactionTerminatedException | KernelException e) {
            Status.Code statusCode = ((Status.HasStatus)((Object)e)).status().code();
            if (statusCode.classification() == Status.Classification.TransientError) {
                throw new TransientTransactionFailureException(this.closeFailureMessage() + ": " + statusCode.description(), e);
            }
            throw new TransactionFailureException(this.closeFailureMessage(), e);
        }
        catch (Exception e) {
            throw new TransactionFailureException(this.closeFailureMessage(), e);
        }
    }

    private String closeFailureMessage() {
        return this.successCalled ? "Transaction was marked as successful, but unable to commit transaction so rolled back." : "Unable to rollback transaction";
    }

    @Override
    public Lock acquireWriteLock(PropertyContainer entity) {
        return locker.exclusiveLock(this.transaction, entity);
    }

    @Override
    public Lock acquireReadLock(PropertyContainer entity) {
        return locker.sharedLock(this.transaction, entity);
    }

    @Override
    public Transaction.Type transactionType() {
        return this.transaction.transactionType();
    }

    @Override
    public SecurityContext securityContext() {
        return this.transaction.securityContext();
    }

    @Override
    public KernelTransaction.Revertable overrideWith(SecurityContext context) {
        return this.transaction.overrideWith(context);
    }

    @Override
    public Optional<Status> terminationReason() {
        return this.transaction.getReasonIfTerminated();
    }

    @Override
    public void setMetaData(Map<String, Object> txMeta) {
        this.transaction.setMetaData(txMeta);
    }
}

