/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorCounters;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.operations.QueryRegistrationOperations;
import org.neo4j.kernel.impl.query.clientconnection.ClientConnectionInfo;
import org.neo4j.kernel.impl.util.MonotonicCounter;
import org.neo4j.resources.CpuClock;
import org.neo4j.resources.HeapAllocation;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.values.virtual.MapValue;

public class StackingQueryRegistrationOperations
implements QueryRegistrationOperations {
    private final MonotonicCounter lastQueryId = MonotonicCounter.newAtomicMonotonicCounter();
    private final SystemNanoClock clock;
    private final AtomicReference<CpuClock> cpuClockRef;
    private final AtomicReference<HeapAllocation> heapAllocationRef;

    public StackingQueryRegistrationOperations(SystemNanoClock clock, AtomicReference<CpuClock> cpuClockRef, AtomicReference<HeapAllocation> heapAllocationRef) {
        this.clock = clock;
        this.cpuClockRef = cpuClockRef;
        this.heapAllocationRef = heapAllocationRef;
    }

    @Override
    public Stream<ExecutingQuery> executingQueries(KernelStatement statement2) {
        return statement2.executingQueryList().queries();
    }

    @Override
    public void registerExecutingQuery(KernelStatement statement2, ExecutingQuery executingQuery) {
        statement2.startQueryExecution(executingQuery);
    }

    @Override
    public ExecutingQuery startQueryExecution(KernelStatement statement2, ClientConnectionInfo clientConnection, String queryText, MapValue queryParameters) {
        long queryId = this.lastQueryId.incrementAndGet();
        Thread thread = Thread.currentThread();
        long threadId = thread.getId();
        String threadName = thread.getName();
        ExecutingQuery executingQuery = new ExecutingQuery(queryId, clientConnection, statement2.username(), queryText, queryParameters, statement2.getTransaction().getMetaData(), () -> statement2.locks().activeLockCount(), (PageCursorCounters)statement2.getPageCursorTracer(), threadId, threadName, this.clock, this.cpuClockRef.get(), this.heapAllocationRef.get());
        this.registerExecutingQuery(statement2, executingQuery);
        return executingQuery;
    }

    @Override
    public void unregisterExecutingQuery(KernelStatement statement2, ExecutingQuery executingQuery) {
        statement2.stopQueryExecution(executingQuery);
    }
}

