/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema.constraints;

import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.LabelSchemaSupplier;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaUtil;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexDescriptorFactory;

public abstract class IndexBackedConstraintDescriptor
extends ConstraintDescriptor
implements LabelSchemaSupplier {
    private final LabelSchemaDescriptor schema;

    IndexBackedConstraintDescriptor(ConstraintDescriptor.Type type, LabelSchemaDescriptor schema) {
        super(type);
        this.schema = schema;
    }

    public LabelSchemaDescriptor schema() {
        return this.schema;
    }

    public IndexDescriptor ownedIndexDescriptor() {
        return IndexDescriptorFactory.uniqueForSchema((SchemaDescriptor)this.schema);
    }

    public String prettyPrint(TokenNameLookup tokenNameLookup) {
        String labelName = this.escapeLabelOrRelTyp(tokenNameLookup.labelGetName(this.schema.getLabelId()));
        String nodeName = labelName.toLowerCase();
        return String.format("CONSTRAINT ON ( %s:%s ) ASSERT %s IS %s", nodeName, labelName, this.formatProperties(this.schema.getPropertyIds(), tokenNameLookup, nodeName), this.constraintTypeText());
    }

    protected abstract String constraintTypeText();

    protected String formatProperties(int[] propertyIds, TokenNameLookup tokenNameLookup, String nodeName) {
        return SchemaUtil.niceProperties((TokenNameLookup)tokenNameLookup, (int[])propertyIds, (String)(nodeName + "."), (propertyIds.length > 1 ? 1 : 0) != 0);
    }
}

