/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufUtil;
import org.neo4j.driver.internal.shaded.io.netty.buffer.PooledByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.util.Recycler;

final class PooledDirectByteBuf
extends PooledByteBuf<ByteBuffer> {
    private static final Recycler<PooledDirectByteBuf> RECYCLER = new Recycler<PooledDirectByteBuf>(){

        @Override
        protected PooledDirectByteBuf newObject(Recycler.Handle<PooledDirectByteBuf> handle) {
            return new PooledDirectByteBuf(handle, 0);
        }
    };

    static PooledDirectByteBuf newInstance(int maxCapacity) {
        PooledDirectByteBuf buf = RECYCLER.get();
        buf.reuse(maxCapacity);
        return buf;
    }

    private PooledDirectByteBuf(Recycler.Handle<PooledDirectByteBuf> recyclerHandle, int maxCapacity) {
        super(recyclerHandle, maxCapacity);
    }

    @Override
    protected ByteBuffer newInternalNioBuffer(ByteBuffer memory) {
        return memory.duplicate();
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    protected byte _getByte(int index) {
        return ((ByteBuffer)this.memory).get(this.idx(index));
    }

    @Override
    protected short _getShort(int index) {
        return ((ByteBuffer)this.memory).getShort(this.idx(index));
    }

    @Override
    protected short _getShortLE(int index) {
        return ByteBufUtil.swapShort(this._getShort(index));
    }

    @Override
    protected int _getUnsignedMedium(int index) {
        index = this.idx(index);
        return (((ByteBuffer)this.memory).get(index) & 0xFF) << 16 | (((ByteBuffer)this.memory).get(index + 1) & 0xFF) << 8 | ((ByteBuffer)this.memory).get(index + 2) & 0xFF;
    }

    @Override
    protected int _getUnsignedMediumLE(int index) {
        index = this.idx(index);
        return ((ByteBuffer)this.memory).get(index) & 0xFF | (((ByteBuffer)this.memory).get(index + 1) & 0xFF) << 8 | (((ByteBuffer)this.memory).get(index + 2) & 0xFF) << 16;
    }

    @Override
    protected int _getInt(int index) {
        return ((ByteBuffer)this.memory).getInt(this.idx(index));
    }

    @Override
    protected int _getIntLE(int index) {
        return ByteBufUtil.swapInt(this._getInt(index));
    }

    @Override
    protected long _getLong(int index) {
        return ((ByteBuffer)this.memory).getLong(this.idx(index));
    }

    @Override
    protected long _getLongLE(int index) {
        return ByteBufUtil.swapLong(this._getLong(index));
    }

    @Override
    public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length2) {
        this.checkDstIndex(index, length2, dstIndex, dst.capacity());
        if (dst.hasArray()) {
            this.getBytes(index, dst.array(), dst.arrayOffset() + dstIndex, length2);
        } else if (dst.nioBufferCount() > 0) {
            for (ByteBuffer bb : dst.nioBuffers(dstIndex, length2)) {
                int bbLen = bb.remaining();
                this.getBytes(index, bb);
                index += bbLen;
            }
        } else {
            dst.setBytes(dstIndex, this, index, length2);
        }
        return this;
    }

    @Override
    public ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length2) {
        this.getBytes(index, dst, dstIndex, length2, false);
        return this;
    }

    private void getBytes(int index, byte[] dst, int dstIndex, int length2, boolean internal) {
        this.checkDstIndex(index, length2, dstIndex, dst.length);
        ByteBuffer tmpBuf = internal ? this.internalNioBuffer() : ((ByteBuffer)this.memory).duplicate();
        index = this.idx(index);
        tmpBuf.clear().position(index).limit(index + length2);
        tmpBuf.get(dst, dstIndex, length2);
    }

    @Override
    public ByteBuf readBytes(byte[] dst, int dstIndex, int length2) {
        this.checkReadableBytes(length2);
        this.getBytes(this.readerIndex, dst, dstIndex, length2, true);
        this.readerIndex += length2;
        return this;
    }

    @Override
    public ByteBuf getBytes(int index, ByteBuffer dst) {
        this.getBytes(index, dst, false);
        return this;
    }

    private void getBytes(int index, ByteBuffer dst, boolean internal) {
        this.checkIndex(index, dst.remaining());
        ByteBuffer tmpBuf = internal ? this.internalNioBuffer() : ((ByteBuffer)this.memory).duplicate();
        index = this.idx(index);
        tmpBuf.clear().position(index).limit(index + dst.remaining());
        dst.put(tmpBuf);
    }

    @Override
    public ByteBuf readBytes(ByteBuffer dst) {
        int length2 = dst.remaining();
        this.checkReadableBytes(length2);
        this.getBytes(this.readerIndex, dst, true);
        this.readerIndex += length2;
        return this;
    }

    @Override
    public ByteBuf getBytes(int index, OutputStream out, int length2) throws IOException {
        this.getBytes(index, out, length2, false);
        return this;
    }

    private void getBytes(int index, OutputStream out, int length2, boolean internal) throws IOException {
        this.checkIndex(index, length2);
        if (length2 == 0) {
            return;
        }
        byte[] tmp = new byte[length2];
        ByteBuffer tmpBuf = internal ? this.internalNioBuffer() : ((ByteBuffer)this.memory).duplicate();
        tmpBuf.clear().position(this.idx(index));
        tmpBuf.get(tmp);
        out.write(tmp);
    }

    @Override
    public ByteBuf readBytes(OutputStream out, int length2) throws IOException {
        this.checkReadableBytes(length2);
        this.getBytes(this.readerIndex, out, length2, true);
        this.readerIndex += length2;
        return this;
    }

    @Override
    public int getBytes(int index, GatheringByteChannel out, int length2) throws IOException {
        return this.getBytes(index, out, length2, false);
    }

    private int getBytes(int index, GatheringByteChannel out, int length2, boolean internal) throws IOException {
        this.checkIndex(index, length2);
        if (length2 == 0) {
            return 0;
        }
        ByteBuffer tmpBuf = internal ? this.internalNioBuffer() : ((ByteBuffer)this.memory).duplicate();
        index = this.idx(index);
        tmpBuf.clear().position(index).limit(index + length2);
        return out.write(tmpBuf);
    }

    @Override
    public int getBytes(int index, FileChannel out, long position2, int length2) throws IOException {
        return this.getBytes(index, out, position2, length2, false);
    }

    private int getBytes(int index, FileChannel out, long position2, int length2, boolean internal) throws IOException {
        this.checkIndex(index, length2);
        if (length2 == 0) {
            return 0;
        }
        ByteBuffer tmpBuf = internal ? this.internalNioBuffer() : ((ByteBuffer)this.memory).duplicate();
        index = this.idx(index);
        tmpBuf.clear().position(index).limit(index + length2);
        return out.write(tmpBuf, position2);
    }

    @Override
    public int readBytes(GatheringByteChannel out, int length2) throws IOException {
        this.checkReadableBytes(length2);
        int readBytes = this.getBytes(this.readerIndex, out, length2, true);
        this.readerIndex += readBytes;
        return readBytes;
    }

    @Override
    public int readBytes(FileChannel out, long position2, int length2) throws IOException {
        this.checkReadableBytes(length2);
        int readBytes = this.getBytes(this.readerIndex, out, position2, length2, true);
        this.readerIndex += readBytes;
        return readBytes;
    }

    @Override
    protected void _setByte(int index, int value2) {
        ((ByteBuffer)this.memory).put(this.idx(index), (byte)value2);
    }

    @Override
    protected void _setShort(int index, int value2) {
        ((ByteBuffer)this.memory).putShort(this.idx(index), (short)value2);
    }

    @Override
    protected void _setShortLE(int index, int value2) {
        this._setShort(index, ByteBufUtil.swapShort((short)value2));
    }

    @Override
    protected void _setMedium(int index, int value2) {
        index = this.idx(index);
        ((ByteBuffer)this.memory).put(index, (byte)(value2 >>> 16));
        ((ByteBuffer)this.memory).put(index + 1, (byte)(value2 >>> 8));
        ((ByteBuffer)this.memory).put(index + 2, (byte)value2);
    }

    @Override
    protected void _setMediumLE(int index, int value2) {
        index = this.idx(index);
        ((ByteBuffer)this.memory).put(index, (byte)value2);
        ((ByteBuffer)this.memory).put(index + 1, (byte)(value2 >>> 8));
        ((ByteBuffer)this.memory).put(index + 2, (byte)(value2 >>> 16));
    }

    @Override
    protected void _setInt(int index, int value2) {
        ((ByteBuffer)this.memory).putInt(this.idx(index), value2);
    }

    @Override
    protected void _setIntLE(int index, int value2) {
        this._setInt(index, ByteBufUtil.swapInt(value2));
    }

    @Override
    protected void _setLong(int index, long value2) {
        ((ByteBuffer)this.memory).putLong(this.idx(index), value2);
    }

    @Override
    protected void _setLongLE(int index, long value2) {
        this._setLong(index, ByteBufUtil.swapLong(value2));
    }

    @Override
    public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length2) {
        this.checkSrcIndex(index, length2, srcIndex, src.capacity());
        if (src.hasArray()) {
            this.setBytes(index, src.array(), src.arrayOffset() + srcIndex, length2);
        } else if (src.nioBufferCount() > 0) {
            for (ByteBuffer bb : src.nioBuffers(srcIndex, length2)) {
                int bbLen = bb.remaining();
                this.setBytes(index, bb);
                index += bbLen;
            }
        } else {
            src.getBytes(srcIndex, this, index, length2);
        }
        return this;
    }

    @Override
    public ByteBuf setBytes(int index, byte[] src, int srcIndex, int length2) {
        this.checkSrcIndex(index, length2, srcIndex, src.length);
        ByteBuffer tmpBuf = this.internalNioBuffer();
        index = this.idx(index);
        tmpBuf.clear().position(index).limit(index + length2);
        tmpBuf.put(src, srcIndex, length2);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index, ByteBuffer src) {
        this.checkIndex(index, src.remaining());
        ByteBuffer tmpBuf = this.internalNioBuffer();
        if (src == tmpBuf) {
            src = src.duplicate();
        }
        index = this.idx(index);
        tmpBuf.clear().position(index).limit(index + src.remaining());
        tmpBuf.put(src);
        return this;
    }

    @Override
    public int setBytes(int index, InputStream in2, int length2) throws IOException {
        this.checkIndex(index, length2);
        byte[] tmp = new byte[length2];
        int readBytes = in2.read(tmp);
        if (readBytes <= 0) {
            return readBytes;
        }
        ByteBuffer tmpBuf = this.internalNioBuffer();
        tmpBuf.clear().position(this.idx(index));
        tmpBuf.put(tmp, 0, readBytes);
        return readBytes;
    }

    @Override
    public int setBytes(int index, ScatteringByteChannel in2, int length2) throws IOException {
        this.checkIndex(index, length2);
        ByteBuffer tmpBuf = this.internalNioBuffer();
        index = this.idx(index);
        tmpBuf.clear().position(index).limit(index + length2);
        try {
            return in2.read(tmpBuf);
        }
        catch (ClosedChannelException ignored) {
            return -1;
        }
    }

    @Override
    public int setBytes(int index, FileChannel in2, long position2, int length2) throws IOException {
        this.checkIndex(index, length2);
        ByteBuffer tmpBuf = this.internalNioBuffer();
        index = this.idx(index);
        tmpBuf.clear().position(index).limit(index + length2);
        try {
            return in2.read(tmpBuf, position2);
        }
        catch (ClosedChannelException ignored) {
            return -1;
        }
    }

    @Override
    public ByteBuf copy(int index, int length2) {
        this.checkIndex(index, length2);
        ByteBuf copy2 = this.alloc().directBuffer(length2, this.maxCapacity());
        copy2.writeBytes(this, index, length2);
        return copy2;
    }

    @Override
    public int nioBufferCount() {
        return 1;
    }

    @Override
    public ByteBuffer nioBuffer(int index, int length2) {
        this.checkIndex(index, length2);
        index = this.idx(index);
        return ((ByteBuffer)((ByteBuffer)this.memory).duplicate().position(index).limit(index + length2)).slice();
    }

    @Override
    public ByteBuffer[] nioBuffers(int index, int length2) {
        return new ByteBuffer[]{this.nioBuffer(index, length2)};
    }

    @Override
    public ByteBuffer internalNioBuffer(int index, int length2) {
        this.checkIndex(index, length2);
        index = this.idx(index);
        return (ByteBuffer)this.internalNioBuffer().clear().position(index).limit(index + length2);
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public byte[] array() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public int arrayOffset() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public long memoryAddress() {
        throw new UnsupportedOperationException();
    }
}

