/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.ir.v3_5;

import org.neo4j.cypher.internal.ir.v3_5.InterestingOrder;
import org.neo4j.cypher.internal.ir.v3_5.InterestingOrder$;
import org.neo4j.cypher.internal.ir.v3_5.PlannerQuery;
import org.neo4j.cypher.internal.ir.v3_5.QueryGraph;
import org.neo4j.cypher.internal.ir.v3_5.QueryHorizon;
import org.neo4j.cypher.internal.ir.v3_5.QueryProjection;
import org.neo4j.cypher.internal.ir.v3_5.RegularPlannerQuery;
import org.neo4j.cypher.internal.ir.v3_5.RegularPlannerQuery$;
import org.neo4j.cypher.internal.ir.v3_5.RegularQueryProjection;
import org.neo4j.cypher.internal.ir.v3_5.StrictnessMode;
import org.neo4j.cypher.internal.v3_5.ast.Hint;
import org.neo4j.cypher.internal.v3_5.expressions.Expression;
import org.neo4j.cypher.internal.v3_5.expressions.LabelName;
import org.neo4j.cypher.internal.v3_5.expressions.Variable;
import org.neo4j.cypher.internal.v3_5.util.InternalException;
import org.neo4j.cypher.internal.v3_5.util.InternalException$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;

public abstract class PlannerQuery$class {
    public static boolean readOnly(PlannerQuery $this) {
        return $this.queryGraph().readOnly() && $this.horizon().readOnly() && $this.tail().forall((Function1<PlannerQuery, Object>)((Object)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(PlannerQuery x$1) {
                return x$1.readOnly();
            }
        }));
    }

    public static Option preferredStrictness(PlannerQuery $this) {
        return $this.horizon().preferredStrictness().orElse(new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlannerQuery $outer;

            public final Option<StrictnessMode> apply() {
                return this.$outer.tail().flatMap(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Option<StrictnessMode> apply(PlannerQuery x$2) {
                        return x$2.preferredStrictness();
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static PlannerQuery last(PlannerQuery $this) {
        return $this.tail().map(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final PlannerQuery apply(PlannerQuery x$3) {
                return x$3.last();
            }
        }).getOrElse(new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlannerQuery $outer;

            public final PlannerQuery apply() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static QueryGraph lastQueryGraph(PlannerQuery $this) {
        return $this.last().queryGraph();
    }

    public static QueryHorizon lastQueryHorizon(PlannerQuery $this) {
        return $this.last().horizon();
    }

    public static PlannerQuery withTail(PlannerQuery $this, PlannerQuery newTail) {
        Option<PlannerQuery> option = $this.tail();
        if (None$.MODULE$.equals(option)) {
            Some<PlannerQuery> x$11 = new Some<PlannerQuery>(newTail);
            QueryGraph x$12 = $this.copy$default$1();
            InterestingOrder x$13 = $this.copy$default$2();
            QueryHorizon x$14 = $this.copy$default$3();
            PlannerQuery plannerQuery = $this.copy(x$12, x$13, x$14, x$11);
            return plannerQuery;
        }
        if (option instanceof Some) {
            throw new InternalException("Attempt to set a second tail on a query graph", InternalException$.MODULE$.$lessinit$greater$default$2());
        }
        throw new MatchError(option);
    }

    public static PlannerQuery withoutHints(PlannerQuery $this, GenSeq hintsToIgnore) {
        QueryGraph x$15 = $this.queryGraph().withoutHints(hintsToIgnore);
        Option<PlannerQuery> x$16 = $this.tail().map(new Serializable($this, hintsToIgnore){
            public static final long serialVersionUID = 0L;
            private final GenSeq hintsToIgnore$1;

            public final PlannerQuery apply(PlannerQuery x) {
                return x.withoutHints(this.hintsToIgnore$1);
            }
            {
                this.hintsToIgnore$1 = hintsToIgnore$1;
            }
        });
        InterestingOrder x$17 = $this.copy$default$2();
        QueryHorizon x$18 = $this.copy$default$3();
        return $this.copy(x$15, x$17, x$18, x$16);
    }

    public static PlannerQuery withHorizon(PlannerQuery $this, QueryHorizon horizon) {
        QueryHorizon x$19 = horizon;
        QueryGraph x$20 = $this.copy$default$1();
        InterestingOrder x$21 = $this.copy$default$2();
        Option<PlannerQuery> x$22 = $this.copy$default$4();
        return $this.copy(x$20, x$21, x$19, x$22);
    }

    public static PlannerQuery withQueryGraph(PlannerQuery $this, QueryGraph queryGraph) {
        return $this.copy(queryGraph, $this.copy$default$2(), $this.copy$default$3(), $this.copy$default$4());
    }

    public static PlannerQuery withInterestingOrder(PlannerQuery $this, InterestingOrder interestingOrder) {
        InterestingOrder x$23 = interestingOrder;
        QueryGraph x$24 = $this.copy$default$1();
        QueryHorizon x$25 = $this.copy$default$3();
        Option<PlannerQuery> x$26 = $this.copy$default$4();
        return $this.copy(x$24, x$23, x$25, x$26);
    }

    public static PlannerQuery withTailInterestingOrder(PlannerQuery $this, InterestingOrder interestingOrder) {
        return (PlannerQuery)PlannerQuery$class.f$1($this, $this, interestingOrder)._1();
    }

    public static boolean isCoveredByHints(PlannerQuery $this, PlannerQuery other2) {
        Seq<Hint> seq = other2.allHints();
        return $this.allHints().forall((Function1<Hint, Object>)((Object)new Serializable($this, seq){
            public static final long serialVersionUID = 0L;
            private final Seq eta$0$1$1;

            public final boolean apply(Object elem2) {
                return this.eta$0$1$1.contains(elem2);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        }));
    }

    public static Seq allHints(PlannerQuery $this) {
        Option<PlannerQuery> option;
        block4: {
            Seq<Hint> seq;
            block3: {
                block2: {
                    option = $this.tail();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    PlannerQuery tailPlannerQuery = (PlannerQuery)some.x();
                    seq = $this.queryGraph().allHints().$plus$plus(tailPlannerQuery.allHints(), Seq$.MODULE$.canBuildFrom());
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                seq = $this.queryGraph().allHints();
            }
            return seq;
        }
        throw new MatchError(option);
    }

    public static int numHints(PlannerQuery $this) {
        return $this.allHints().size();
    }

    public static PlannerQuery amendQueryGraph(PlannerQuery $this, Function1 f) {
        return $this.withQueryGraph((QueryGraph)f.apply($this.queryGraph()));
    }

    public static PlannerQuery updateHorizon(PlannerQuery $this, Function1 f) {
        return $this.withHorizon((QueryHorizon)f.apply($this.horizon()));
    }

    public static PlannerQuery updateQueryProjection(PlannerQuery $this, Function1 f) {
        QueryHorizon queryHorizon = $this.horizon();
        if (queryHorizon instanceof QueryProjection) {
            QueryProjection queryProjection = (QueryProjection)queryHorizon;
            PlannerQuery plannerQuery = $this.withHorizon((QueryHorizon)f.apply(queryProjection));
            return plannerQuery;
        }
        throw new InternalException("Tried updating projection when there was no projection there", InternalException$.MODULE$.$lessinit$greater$default$2());
    }

    public static PlannerQuery updateTail(PlannerQuery $this, Function1 f) {
        Option<PlannerQuery> option;
        block4: {
            PlannerQuery plannerQuery;
            block3: {
                block2: {
                    option = $this.tail();
                    if (!None$.MODULE$.equals(option)) break block2;
                    plannerQuery = $this;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                PlannerQuery tailQuery = (PlannerQuery)some.x();
                Some<PlannerQuery> x$39 = new Some<PlannerQuery>((PlannerQuery)f.apply(tailQuery));
                QueryGraph x$40 = $this.copy$default$1();
                InterestingOrder x$41 = $this.copy$default$2();
                QueryHorizon x$42 = $this.copy$default$3();
                plannerQuery = $this.copy(x$40, x$41, x$42, x$39);
            }
            return plannerQuery;
        }
        throw new MatchError(option);
    }

    public static PlannerQuery updateTailOrSelf(PlannerQuery $this, Function1 f) {
        Option<PlannerQuery> option;
        block4: {
            PlannerQuery plannerQuery;
            block3: {
                block2: {
                    option = $this.tail();
                    if (!None$.MODULE$.equals(option)) break block2;
                    plannerQuery = (PlannerQuery)f.apply($this);
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                plannerQuery = $this.updateTail((Function1<PlannerQuery, PlannerQuery>)((Object)new Serializable($this, f){
                    public static final long serialVersionUID = 0L;
                    private final Function1 f$2;

                    public final PlannerQuery apply(PlannerQuery x$5) {
                        return x$5.updateTailOrSelf(this.f$2);
                    }
                    {
                        this.f$2 = f$2;
                    }
                }));
            }
            return plannerQuery;
        }
        throw new MatchError(option);
    }

    public static PlannerQuery tailOrSelf(PlannerQuery $this) {
        Option<PlannerQuery> option;
        block4: {
            PlannerQuery plannerQuery;
            block3: {
                block2: {
                    option = $this.tail();
                    if (!None$.MODULE$.equals(option)) break block2;
                    plannerQuery = $this;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                PlannerQuery t = (PlannerQuery)some.x();
                plannerQuery = t.tailOrSelf();
            }
            return plannerQuery;
        }
        throw new MatchError(option);
    }

    public static boolean exists(PlannerQuery $this, Function1 f) {
        return BoxesRunTime.unboxToBoolean(f.apply($this)) || $this.tail().exists((Function1<PlannerQuery, Object>)((Object)new Serializable($this, f){
            public static final long serialVersionUID = 0L;
            private final Function1 f$3;

            public final boolean apply(PlannerQuery x$6) {
                return x$6.exists(this.f$3);
            }
            {
                this.f$3 = f$3;
            }
        }));
    }

    public static PlannerQuery $plus$plus(PlannerQuery $this, PlannerQuery other2) {
        Tuple2<QueryHorizon, QueryHorizon> tuple2 = new Tuple2<QueryHorizon, QueryHorizon>($this.horizon(), other2.horizon());
        if (tuple2 != null) {
            QueryHorizon a = tuple2._1();
            QueryHorizon b = tuple2._2();
            if (a instanceof RegularQueryProjection) {
                RegularQueryProjection regularQueryProjection = (RegularQueryProjection)a;
                if (b instanceof RegularQueryProjection) {
                    RegularQueryProjection regularQueryProjection2 = (RegularQueryProjection)b;
                    RegularQueryProjection x$43 = regularQueryProjection.$plus$plus(regularQueryProjection2);
                    QueryGraph x$44 = $this.queryGraph().$plus$plus(other2.queryGraph());
                    Option x$45 = PlannerQuery$class.either($this, $this.tail(), other2.tail());
                    InterestingOrder x$46 = RegularPlannerQuery$.MODULE$.apply$default$2();
                    RegularPlannerQuery regularPlannerQuery = new RegularPlannerQuery(x$44, x$46, x$43, x$45);
                    return regularPlannerQuery;
                }
            }
        }
        throw new InternalException("Tried to concatenate non-regular query projections", InternalException$.MODULE$.$lessinit$greater$default$2());
    }

    private static Option either(PlannerQuery $this, Option a, Option b) {
        Tuple2<Option, Option> tuple2;
        block7: {
            Option option;
            block6: {
                block5: {
                    tuple2 = new Tuple2<Option, Option>(a, b);
                    if (tuple2 != null) {
                        Option option2 = tuple2._1();
                        Option option3 = tuple2._2();
                        if (option2 instanceof Some && option3 instanceof Some) {
                            throw new InternalException("Can't join two query graphs with different SKIP", InternalException$.MODULE$.$lessinit$greater$default$2());
                        }
                    }
                    if (tuple2 == null) break block5;
                    Option s2 = tuple2._1();
                    Option option4 = tuple2._2();
                    if (!(s2 instanceof Some)) break block5;
                    Some some = (Some)s2;
                    if (!None$.MODULE$.equals(option4)) break block5;
                    option = some;
                    break block6;
                }
                if (tuple2 == null) break block7;
                Option option5 = tuple2._1();
                Option s3 = tuple2._2();
                if (!None$.MODULE$.equals(option5)) break block7;
                option = s3;
            }
            return option;
        }
        throw new MatchError(tuple2);
    }

    public static QueryGraph copy$default$1(PlannerQuery $this) {
        return $this.queryGraph();
    }

    public static InterestingOrder copy$default$2(PlannerQuery $this) {
        return $this.interestingOrder();
    }

    public static QueryHorizon copy$default$3(PlannerQuery $this) {
        return $this.horizon();
    }

    public static Option copy$default$4(PlannerQuery $this) {
        return $this.tail();
    }

    public static PlannerQuery foldMap(PlannerQuery $this, Function2 f) {
        Option<PlannerQuery> option;
        block4: {
            PlannerQuery plannerQuery;
            block3: {
                block2: {
                    option = $this.tail();
                    if (!None$.MODULE$.equals(option)) break block2;
                    plannerQuery = $this;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                PlannerQuery oldTail = (PlannerQuery)some.x();
                PlannerQuery newTail = (PlannerQuery)f.apply($this, oldTail);
                Some<PlannerQuery> x$47 = new Some<PlannerQuery>(newTail.foldMap(f));
                QueryGraph x$48 = $this.copy$default$1();
                InterestingOrder x$49 = $this.copy$default$2();
                QueryHorizon x$50 = $this.copy$default$3();
                plannerQuery = $this.copy(x$48, x$49, x$50, x$47);
            }
            return plannerQuery;
        }
        throw new MatchError(option);
    }

    public static Object fold(PlannerQuery $this, Object in2, Function2 f) {
        return PlannerQuery$class.recurse$1($this, in2, $this, f);
    }

    public static Seq allQueryGraphs(PlannerQuery $this) {
        return $this.allPlannerQueries().map(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final QueryGraph apply(PlannerQuery x$7) {
                return x$7.queryGraph();
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static Seq allPlannerQueries(PlannerQuery $this) {
        return PlannerQuery$class.loop$1($this, (Seq)Seq$.MODULE$.empty(), new Some<PlannerQuery>($this));
    }

    public static Map labelInfo(PlannerQuery $this) {
        Map map2;
        Map<String, Set<LabelName>> labelInfo2 = $this.lastQueryGraph().selections().labelInfo();
        QueryHorizon queryHorizon = $this.lastQueryHorizon();
        if (queryHorizon instanceof QueryProjection) {
            QueryProjection queryProjection = (QueryProjection)queryHorizon;
            map2 = queryProjection.projections().collect((PartialFunction<String, Expression>)((Object)new Serializable($this, labelInfo2){
                public static final long serialVersionUID = 0L;
                private final Map labelInfo$1;

                /*
                 * WARNING - void declaration
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends Tuple2<String, Expression>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    void var8_10;
                    A1 A1 = x1;
                    if (A1 != null) {
                        Variable variable;
                        String name;
                        String projectedName = A1._1();
                        Expression expression = A1._2();
                        if (expression instanceof Variable && this.labelInfo$1.contains(name = (variable = (Variable)expression).name())) {
                            Tuple2<String, B> tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(projectedName), this.labelInfo$1.apply(name));
                            return var8_10;
                        }
                    }
                    B1 B1 = function1.apply(x1);
                    return var8_10;
                }

                public final boolean isDefinedAt(Tuple2<String, Expression> x1) {
                    Variable variable;
                    String name;
                    Expression expression;
                    Tuple2<String, Expression> tuple2 = x1;
                    boolean bl = tuple2 != null && (expression = tuple2._2()) instanceof Variable && this.labelInfo$1.contains(name = (variable = (Variable)expression).name());
                    return bl;
                }
                {
                    this.labelInfo$1 = labelInfo$1;
                }
            }), Map$.MODULE$.canBuildFrom());
        } else {
            map2 = Predef$.MODULE$.Map().empty();
        }
        Map projectedLabelInfo = map2;
        return labelInfo2.$plus$plus(projectedLabelInfo);
    }

    private static final Tuple2 f$1(PlannerQuery $this, PlannerQuery plannerQuery, InterestingOrder interestingOrder$1) {
        Option<PlannerQuery> option;
        block9: {
            Tuple2 tuple2;
            block10: {
                Tuple2<PlannerQuery, InterestingOrder> tuple22;
                block8: {
                    Tuple2<PlannerQuery, InterestingOrder> tuple23;
                    Tuple2<PlannerQuery, InterestingOrder> tuple24;
                    block7: {
                        option = plannerQuery.tail();
                        if (!None$.MODULE$.equals(option)) break block7;
                        InterestingOrder x$27 = interestingOrder$1;
                        QueryGraph x$28 = plannerQuery.copy$default$1();
                        QueryHorizon x$29 = plannerQuery.copy$default$3();
                        Option<PlannerQuery> x$30 = plannerQuery.copy$default$4();
                        tuple22 = new Tuple2<PlannerQuery, InterestingOrder>(plannerQuery.copy(x$28, x$27, x$29, x$30), interestingOrder$1.asInteresting());
                        break block8;
                    }
                    if (!(option instanceof Some)) break block9;
                    Some some = (Some)option;
                    PlannerQuery q = (PlannerQuery)some.x();
                    tuple2 = PlannerQuery$class.f$1($this, q, interestingOrder$1);
                    if (tuple2 == null) break block10;
                    PlannerQuery newTail = (PlannerQuery)tuple2._1();
                    InterestingOrder tailOrder = (InterestingOrder)tuple2._2();
                    Tuple2<PlannerQuery, InterestingOrder> tuple25 = tuple24 = new Tuple2<PlannerQuery, InterestingOrder>(newTail, tailOrder);
                    PlannerQuery newTail2 = tuple25._1();
                    InterestingOrder tailOrder2 = tuple25._2();
                    if (plannerQuery.interestingOrder().isEmpty()) {
                        InterestingOrder reverseProjected;
                        InterestingOrder interestingOrder;
                        QueryHorizon queryHorizon = plannerQuery.horizon();
                        if (queryHorizon instanceof QueryProjection) {
                            QueryProjection queryProjection = (QueryProjection)queryHorizon;
                            interestingOrder = tailOrder2.withReverseProjectedColumns(queryProjection.projections(), newTail2.queryGraph().argumentIds());
                        } else {
                            interestingOrder = tailOrder2;
                        }
                        InterestingOrder x$31 = reverseProjected = interestingOrder;
                        Some<PlannerQuery> x$32 = new Some<PlannerQuery>(newTail2);
                        QueryGraph x$33 = plannerQuery.copy$default$1();
                        QueryHorizon x$34 = plannerQuery.copy$default$3();
                        Tuple2<PlannerQuery, InterestingOrder> tuple26 = new Tuple2<PlannerQuery, InterestingOrder>(plannerQuery.copy(x$33, x$31, x$34, x$32), reverseProjected);
                        tuple23 = tuple26;
                    } else {
                        Some<PlannerQuery> x$35 = new Some<PlannerQuery>(newTail2);
                        QueryGraph x$36 = plannerQuery.copy$default$1();
                        InterestingOrder x$37 = plannerQuery.copy$default$2();
                        QueryHorizon x$38 = plannerQuery.copy$default$3();
                        Tuple2<PlannerQuery, InterestingOrder> tuple27 = new Tuple2<PlannerQuery, InterestingOrder>(plannerQuery.copy(x$36, x$37, x$38, x$35), InterestingOrder$.MODULE$.empty());
                        tuple23 = tuple27;
                    }
                    tuple22 = tuple23;
                }
                return tuple22;
            }
            throw new MatchError(tuple2);
        }
        throw new MatchError(option);
    }

    private static final Object recurse$1(PlannerQuery $this, Object acc, PlannerQuery pq, Function2 f$4) {
        Option<PlannerQuery> option;
        Object nextAcc;
        while (true) {
            PlannerQuery tailPQ;
            nextAcc = f$4.apply(acc, pq);
            option = pq.tail();
            if (!(option instanceof Some)) break;
            Some some = (Some)option;
            pq = tailPQ = (PlannerQuery)some.x();
            acc = nextAcc;
        }
        if (None$.MODULE$.equals(option)) {
            Object r = nextAcc;
            return r;
        }
        throw new MatchError(option);
    }

    private static final Seq loop$1(PlannerQuery $this, Seq acc, Option remaining) {
        Option<PlannerQuery> option;
        while (true) {
            if (None$.MODULE$.equals(option = remaining)) {
                Seq seq = acc;
                return seq;
            }
            if (!(option instanceof Some)) break;
            Some some = (Some)option;
            PlannerQuery inner2 = (PlannerQuery)some.x();
            remaining = inner2.tail();
            acc = acc.$colon$plus(inner2, Seq$.MODULE$.canBuildFrom());
        }
        throw new MatchError(option);
    }

    public static void $init$(PlannerQuery $this) {
    }
}

