/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.repair;

import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

public enum RelationshipChainField {
    FIRST_NEXT{

        @Override
        public long relOf(RelationshipRecord rel) {
            return rel.getFirstNextRel();
        }

        @Override
        public boolean endOfChain(RelationshipRecord rel) {
            return rel.getFirstNextRel() == (long)Record.NO_NEXT_RELATIONSHIP.intValue();
        }
    }
    ,
    FIRST_PREV{

        @Override
        public long relOf(RelationshipRecord rel) {
            return rel.getFirstPrevRel();
        }

        @Override
        public boolean endOfChain(RelationshipRecord rel) {
            return rel.isFirstInFirstChain();
        }
    }
    ,
    SECOND_NEXT{

        @Override
        public long relOf(RelationshipRecord rel) {
            return rel.getSecondNextRel();
        }

        @Override
        public boolean endOfChain(RelationshipRecord rel) {
            return rel.getSecondNextRel() == (long)Record.NO_NEXT_RELATIONSHIP.intValue();
        }
    }
    ,
    SECOND_PREV{

        @Override
        public long relOf(RelationshipRecord rel) {
            return rel.getSecondPrevRel();
        }

        @Override
        public boolean endOfChain(RelationshipRecord rel) {
            return rel.isFirstInSecondChain();
        }
    };


    public abstract long relOf(RelationshipRecord var1);

    public abstract boolean endOfChain(RelationshipRecord var1);
}

