/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps;

import java.io.Serializable;
import java.rmi.RemoteException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.Continuation;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.kernel.GraphDatabaseShellServer;
import org.neo4j.shell.kernel.apps.NonTransactionProvidingApp;

public class Begin
extends NonTransactionProvidingApp {
    private static final String TRANSACTION = "TRANSACTION";

    @Override
    public String getDescription() {
        return "Opens a transaction";
    }

    @Override
    protected Continuation exec(AppCommandParser parser, Session session, Output out) throws RemoteException {
        int count;
        String lineWithoutApp = parser.getLineWithoutApp();
        if (!this.acceptableText(lineWithoutApp)) {
            out.println((Serializable)((Object)"Error: To open a transaction, write BEGIN TRANSACTION"));
            return Continuation.INPUT_COMPLETE;
        }
        KernelTransaction tx = Begin.currentTransaction(this.getServer());
        this.getServer().getDb().beginTx();
        Integer txCount = session.getCommitCount();
        if (txCount == null) {
            if (tx == null) {
                count = 0;
                out.println((Serializable)((Object)"Transaction started"));
            } else {
                count = 1;
                out.println((Serializable)((Object)"Warning: transaction found that was not started by the shell."));
            }
        } else {
            count = txCount;
            out.println((Serializable)((Object)String.format("Nested transaction started (Tx count: %d)", count + 1)));
        }
        session.setCommitCount(++count);
        return Continuation.INPUT_COMPLETE;
    }

    private boolean acceptableText(String line) {
        return line != null && line.length() <= TRANSACTION.length() && TRANSACTION.startsWith(line.toUpperCase());
    }

    public static KernelTransaction currentTransaction(GraphDatabaseShellServer server) {
        return ((ThreadToStatementContextBridge)server.getDb().getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class)).getTopLevelTransactionBoundToThisThread(false);
    }
}

