/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.rest.management.console.ConsoleService;
import org.neo4j.server.web.WebServer;

public class ConsoleModule
implements ServerModule {
    private final WebServer webServer;
    private Config config;

    public ConsoleModule(WebServer webServer, Config config) {
        this.webServer = webServer;
        this.config = config;
    }

    @Override
    public void start() {
        if (((Boolean)this.config.get(ServerSettings.console_module_enabled)).booleanValue()) {
            String serverMountPoint = this.managementApiUri().toString();
            this.webServer.addJAXRSClasses(this.getClassNames(), serverMountPoint, null);
        }
    }

    private List<String> getClassNames() {
        return Collections.singletonList(ConsoleService.class.getName());
    }

    private URI managementApiUri() {
        return (URI)this.config.get(ServerSettings.management_api_path);
    }

    @Override
    public void stop() {
    }
}

