/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.HashMap;
import java.util.List;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.virtual.ErrorValue;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeReference;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.RelationshipReference;
import org.neo4j.values.virtual.RelationshipValue;

public final class VirtualValues {
    public static final MapValue EMPTY_MAP = MapValue.EMPTY;
    public static final ListValue EMPTY_LIST = new ListValue.ArrayListValue(new AnyValue[0]);

    private VirtualValues() {
    }

    public static ListValue list(AnyValue ... values2) {
        return new ListValue.ArrayListValue(values2);
    }

    public static ListValue fromList(List<AnyValue> values2) {
        return new ListValue.JavaListListValue(values2);
    }

    public static ListValue range(long start, long end, long step) {
        return new ListValue.IntegralRangeListValue(start, end, step);
    }

    public static ListValue fromArray(ArrayValue arrayValue) {
        return new ListValue.ArrayValueListValue(arrayValue);
    }

    public static ListValue concat(ListValue ... lists) {
        return new ListValue.ConcatList(lists);
    }

    public static MapValue emptyMap() {
        return EMPTY_MAP;
    }

    public static MapValue map(String[] keys, AnyValue[] values2) {
        assert (keys.length == values2.length);
        HashMap<String, AnyValue> map2 = new HashMap<String, AnyValue>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map2.put(keys[i], values2[i]);
        }
        return new MapValue.MapWrappingMapValue(map2);
    }

    public static ErrorValue error(Exception e) {
        return new ErrorValue(e);
    }

    public static NodeReference node(long id2) {
        return new NodeReference(id2);
    }

    public static RelationshipReference relationship(long id2) {
        return new RelationshipReference(id2);
    }

    public static PathValue path(NodeValue[] nodes, RelationshipValue[] relationships) {
        assert (nodes != null);
        assert (relationships != null);
        if ((nodes.length + relationships.length) % 2 == 0) {
            throw new IllegalArgumentException("Tried to construct a path that is not built like a path: even number of elements");
        }
        return new PathValue.DirectPathValue(nodes, relationships);
    }

    public static NodeValue nodeValue(long id2, TextArray labels2, MapValue properties) {
        return new NodeValue.DirectNodeValue(id2, labels2, properties);
    }

    public static RelationshipValue relationshipValue(long id2, NodeValue startNode, NodeValue endNode, TextValue type, MapValue properties) {
        return new RelationshipValue.DirectRelationshipValue(id2, startNode, endNode, type, properties);
    }
}

