/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.VirtualValue;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ArrayHelpers;
import org.neo4j.values.virtual.VirtualValueGroup;
import org.neo4j.values.virtual.VirtualValues;

public abstract class ListValue
extends VirtualValue
implements SequenceValue,
Iterable<AnyValue> {
    public abstract int size();

    @Override
    public abstract AnyValue value(int var1);

    @Override
    public String getTypeName() {
        return "List";
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean nonEmpty() {
        return this.size() != 0;
    }

    public boolean storable() {
        return false;
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder(this.getTypeName() + "{");
        for (i = 0; i < this.size() - 1; ++i) {
            sb.append(this.value(i));
            sb.append(", ");
        }
        if (this.size() > 0) {
            sb.append(this.value(i));
        }
        sb.append('}');
        return sb.toString();
    }

    public ArrayValue toStorableArray() {
        throw new UnsupportedOperationException("List cannot be turned into a storable array");
    }

    @Override
    public boolean isSequenceValue() {
        return true;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapSequence(this);
    }

    @Override
    public boolean equals(VirtualValue other2) {
        return other2 != null && other2.isSequenceValue() && this.equals((SequenceValue)((Object)other2));
    }

    public AnyValue head() {
        int size2 = this.size();
        if (size2 == 0) {
            throw new NoSuchElementException("head of empty list");
        }
        return this.value(0);
    }

    public AnyValue last() {
        int size2 = this.size();
        if (size2 == 0) {
            throw new NoSuchElementException("last of empty list");
        }
        return this.value(size2 - 1);
    }

    @Override
    public Iterator<AnyValue> iterator() {
        return new Iterator<AnyValue>(){
            private int count;

            @Override
            public boolean hasNext() {
                return this.count < ListValue.this.size();
            }

            @Override
            public AnyValue next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ListValue.this.value(this.count++);
            }
        };
    }

    @Override
    public VirtualValueGroup valueGroup() {
        return VirtualValueGroup.LIST;
    }

    @Override
    public int length() {
        return this.size();
    }

    @Override
    public int compareTo(VirtualValue other2, Comparator<AnyValue> comparator2) {
        if (!(other2 instanceof ListValue)) {
            throw new IllegalArgumentException("Cannot compare different virtual values");
        }
        ListValue otherList = (ListValue)other2;
        if (this.iterationPreference() == SequenceValue.IterationPreference.RANDOM_ACCESS && otherList.iterationPreference() == SequenceValue.IterationPreference.RANDOM_ACCESS) {
            return this.randomAccessCompareTo(comparator2, otherList);
        }
        return this.iteratorCompareTo(comparator2, otherList);
    }

    public AnyValue[] asArray() {
        switch (this.iterationPreference()) {
            case RANDOM_ACCESS: {
                return this.randomAccessAsArray();
            }
            case ITERATION: {
                return this.iterationAsArray();
            }
        }
        throw new IllegalStateException("not a valid iteration preference");
    }

    @Override
    public int computeHash() {
        switch (this.iterationPreference()) {
            case RANDOM_ACCESS: {
                return this.randomAccessComputeHash();
            }
            case ITERATION: {
                return this.iterationComputeHash();
            }
        }
        throw new IllegalStateException("not a valid iteration preference");
    }

    @Override
    public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
        switch (this.iterationPreference()) {
            case RANDOM_ACCESS: {
                this.randomAccessWriteTo(writer);
                break;
            }
            case ITERATION: {
                this.iterationWriteTo(writer);
                break;
            }
            default: {
                throw new IllegalStateException("not a valid iteration preference");
            }
        }
    }

    public ListValue dropNoValues() {
        return new DropNoValuesListValue(this);
    }

    public ListValue slice(int from2, int to2) {
        int t;
        int f = Math.max(from2, 0);
        if (f > (t = Math.min(to2, this.size()))) {
            return VirtualValues.EMPTY_LIST;
        }
        return new ListSlice(this, f, t);
    }

    public ListValue tail() {
        return this.slice(1, this.size());
    }

    public ListValue drop(int n) {
        int size2 = this.size();
        int start = Math.max(0, Math.min(n, size2));
        return new ListSlice(this, start, size2);
    }

    public ListValue take(int n) {
        int end = Math.max(0, Math.min(n, this.size()));
        return new ListSlice(this, 0, end);
    }

    public ListValue reverse() {
        return new ReversedList(this);
    }

    public ListValue append(AnyValue ... values2) {
        if (values2.length == 0) {
            return this;
        }
        return new AppendList(this, values2);
    }

    public ListValue prepend(AnyValue ... values2) {
        if (values2.length == 0) {
            return this;
        }
        return new PrependList(this, values2);
    }

    private AnyValue[] iterationAsArray() {
        ArrayList<AnyValue> values2 = new ArrayList<AnyValue>();
        int size2 = 0;
        for (AnyValue value2 : this) {
            values2.add(value2);
            ++size2;
        }
        return values2.toArray(new AnyValue[size2]);
    }

    private AnyValue[] randomAccessAsArray() {
        int size2 = this.size();
        AnyValue[] values2 = new AnyValue[size2];
        for (int i = 0; i < values2.length; ++i) {
            values2[i] = this.value(i);
        }
        return values2;
    }

    private int randomAccessComputeHash() {
        int hashCode2 = 1;
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            hashCode2 = 31 * hashCode2 + this.value(i).hashCode();
        }
        return hashCode2;
    }

    private int iterationComputeHash() {
        int hashCode2 = 1;
        for (AnyValue value2 : this) {
            hashCode2 = 31 * hashCode2 + value2.hashCode();
        }
        return hashCode2;
    }

    private <E extends Exception> void randomAccessWriteTo(AnyValueWriter<E> writer) throws E {
        writer.beginList(this.size());
        for (int i = 0; i < this.size(); ++i) {
            this.value(i).writeTo(writer);
        }
        writer.endList();
    }

    private <E extends Exception> void iterationWriteTo(AnyValueWriter<E> writer) throws E {
        writer.beginList(this.size());
        for (AnyValue value2 : this) {
            value2.writeTo(writer);
        }
        writer.endList();
    }

    private int randomAccessCompareTo(Comparator<AnyValue> comparator2, ListValue otherList) {
        int x = Integer.compare(this.length(), otherList.length());
        if (x == 0) {
            for (int i = 0; i < this.length(); ++i) {
                x = comparator2.compare(this.value(i), otherList.value(i));
                if (x == 0) continue;
                return x;
            }
        }
        return x;
    }

    private int iteratorCompareTo(Comparator<AnyValue> comparator2, ListValue otherList) {
        Iterator<AnyValue> thisIterator = this.iterator();
        Iterator<AnyValue> thatIterator = otherList.iterator();
        while (thisIterator.hasNext()) {
            if (!thatIterator.hasNext()) {
                return 1;
            }
            int compare = comparator2.compare(thisIterator.next(), thatIterator.next());
            if (compare == 0) continue;
            return compare;
        }
        if (thatIterator.hasNext()) {
            return -1;
        }
        return 0;
    }

    static final class PrependList
    extends ListValue {
        private final ListValue base;
        private final AnyValue[] prepended;

        PrependList(ListValue base, AnyValue[] prepended) {
            this.base = base;
            this.prepended = prepended;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return this.base.iterationPreference();
        }

        @Override
        public int size() {
            return this.prepended.length + this.base.size();
        }

        @Override
        public AnyValue value(int offset) {
            int size2 = this.base.size();
            if (offset < this.prepended.length) {
                return this.prepended[offset];
            }
            if (offset < size2 + this.prepended.length) {
                return this.base.value(offset - this.prepended.length);
            }
            throw new IndexOutOfBoundsException(offset + " is outside range " + size2);
        }

        @Override
        public Iterator<AnyValue> iterator() {
            switch (this.base.iterationPreference()) {
                case RANDOM_ACCESS: {
                    return super.iterator();
                }
                case ITERATION: {
                    return Iterators.prependTo(this.base.iterator(), (Object[])this.prepended);
                }
            }
            throw new IllegalStateException("unknown iteration preference");
        }
    }

    static final class AppendList
    extends ListValue {
        private final ListValue base;
        private final AnyValue[] appended;

        AppendList(ListValue base, AnyValue[] appended) {
            this.base = base;
            this.appended = appended;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return this.base.iterationPreference();
        }

        @Override
        public int size() {
            return this.base.size() + this.appended.length;
        }

        @Override
        public AnyValue value(int offset) {
            int size2 = this.base.size();
            if (offset < size2) {
                return this.base.value(offset);
            }
            if (offset < size2 + this.appended.length) {
                return this.appended[offset - size2];
            }
            throw new IndexOutOfBoundsException(offset + " is outside range " + size2);
        }

        @Override
        public Iterator<AnyValue> iterator() {
            switch (this.base.iterationPreference()) {
                case RANDOM_ACCESS: {
                    return super.iterator();
                }
                case ITERATION: {
                    return Iterators.appendTo(this.base.iterator(), (Object[])this.appended);
                }
            }
            throw new IllegalStateException("unknown iteration preference");
        }
    }

    static final class ConcatList
    extends ListValue {
        private final ListValue[] lists;
        private int size = -1;

        ConcatList(ListValue[] lists) {
            this.lists = lists;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return SequenceValue.IterationPreference.ITERATION;
        }

        @Override
        public int size() {
            if (this.size < 0) {
                int s2 = 0;
                for (ListValue list2 : this.lists) {
                    s2 += list2.size();
                }
                this.size = s2;
            }
            return this.size;
        }

        @Override
        public AnyValue value(int offset) {
            for (ListValue list2 : this.lists) {
                int size2 = list2.size();
                if (offset < size2) {
                    return list2.value(offset);
                }
                offset -= size2;
            }
            throw new IndexOutOfBoundsException();
        }
    }

    static final class IntegralRangeListValue
    extends ListValue {
        private final long start;
        private final long end;
        private final long step;
        private int length = -1;

        IntegralRangeListValue(long start, long end, long step) {
            this.start = start;
            this.end = end;
            this.step = step;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return SequenceValue.IterationPreference.RANDOM_ACCESS;
        }

        @Override
        public String toString() {
            return "Range(" + this.start + "..." + this.end + ", step = " + this.step + ")";
        }

        @Override
        public int size() {
            if (this.length != -1) {
                return this.length;
            }
            long l = (this.end - this.start) / this.step + 1L;
            if (l > Integer.MAX_VALUE) {
                throw new OutOfMemoryError("Cannot index an collection of size " + l);
            }
            this.length = (int)l;
            return this.length;
        }

        @Override
        public AnyValue value(int offset) {
            if (offset >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            return Values.longValue(this.start + (long)offset * this.step);
        }

        @Override
        public int computeHash() {
            int hashCode2 = 1;
            long current = this.start;
            int size2 = this.size();
            int i = 0;
            while (i < size2) {
                hashCode2 = 31 * hashCode2 + Long.hashCode(current);
                ++i;
                current += this.step;
            }
            return hashCode2;
        }
    }

    static final class DropNoValuesListValue
    extends ListValue {
        private final ListValue inner;
        private int size = -1;

        DropNoValuesListValue(ListValue inner2) {
            this.inner = inner2;
        }

        @Override
        public int size() {
            if (this.size < 0) {
                int s2 = 0;
                for (int i = 0; i < this.inner.size(); ++i) {
                    if (this.inner.value(i) == Values.NO_VALUE) continue;
                    ++s2;
                }
                this.size = s2;
            }
            return this.size;
        }

        @Override
        public AnyValue value(int offset) {
            int actualOffset = 0;
            int size2 = this.inner.size();
            for (int i = 0; i < size2; ++i) {
                AnyValue value2 = this.inner.value(i);
                if (value2 == Values.NO_VALUE) continue;
                if (actualOffset == offset) {
                    return value2;
                }
                ++actualOffset;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public Iterator<AnyValue> iterator() {
            return new FilteredIterator();
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return SequenceValue.IterationPreference.ITERATION;
        }

        private class FilteredIterator
        implements Iterator<AnyValue> {
            private AnyValue next;
            private int index;

            FilteredIterator() {
                this.computeNext();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public AnyValue next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                AnyValue current = this.next;
                this.computeNext();
                return current;
            }

            private void computeNext() {
                if (this.index < DropNoValuesListValue.this.inner.size()) {
                    AnyValue candidate;
                    do {
                        if (this.index < DropNoValuesListValue.this.inner.size()) continue;
                        this.next = null;
                        return;
                    } while ((candidate = DropNoValuesListValue.this.inner.value(this.index++)) == Values.NO_VALUE);
                    this.next = candidate;
                    return;
                }
                this.next = null;
            }
        }
    }

    static final class ReversedList
    extends ListValue {
        private final ListValue inner;

        ReversedList(ListValue inner2) {
            this.inner = inner2;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return this.inner.iterationPreference();
        }

        @Override
        public int size() {
            return this.inner.size();
        }

        @Override
        public AnyValue value(int offset) {
            return this.inner.value(this.size() - 1 - offset);
        }
    }

    static final class ListSlice
    extends ListValue {
        private final ListValue inner;
        private final int from;
        private final int to;

        ListSlice(ListValue inner2, int from2, int to2) {
            assert (from2 >= 0);
            assert (to2 <= inner2.size());
            assert (from2 <= to2);
            this.inner = inner2;
            this.from = from2;
            this.to = to2;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return this.inner.iterationPreference();
        }

        @Override
        public int size() {
            return this.to - this.from;
        }

        @Override
        public AnyValue value(int offset) {
            return this.inner.value(offset + this.from);
        }

        @Override
        public Iterator<AnyValue> iterator() {
            switch (this.inner.iterationPreference()) {
                case RANDOM_ACCESS: {
                    return super.iterator();
                }
                case ITERATION: {
                    return new PrefetchingIterator<AnyValue>(){
                        private int count;
                        private Iterator<AnyValue> innerIterator;
                        {
                            this.innerIterator = inner.iterator();
                        }

                        protected AnyValue fetchNextOrNull() {
                            while (this.count < from && this.innerIterator.hasNext()) {
                                this.innerIterator.next();
                                ++this.count;
                            }
                            if (this.count < from || this.count >= to || !this.innerIterator.hasNext()) {
                                return null;
                            }
                            ++this.count;
                            return this.innerIterator.next();
                        }
                    };
                }
            }
            throw new IllegalStateException("unknown iteration preference");
        }
    }

    static final class JavaListListValue
    extends ListValue {
        private final List<AnyValue> values;

        JavaListListValue(List<AnyValue> values2) {
            assert (values2 != null);
            assert (!ArrayHelpers.containsNull(values2));
            this.values = values2;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return SequenceValue.IterationPreference.ITERATION;
        }

        @Override
        public int size() {
            return this.values.size();
        }

        @Override
        public AnyValue value(int offset) {
            return this.values.get(offset);
        }

        @Override
        public AnyValue[] asArray() {
            return this.values.toArray(new AnyValue[0]);
        }

        @Override
        public int computeHash() {
            return this.values.hashCode();
        }

        @Override
        public Iterator<AnyValue> iterator() {
            return this.values.iterator();
        }
    }

    static final class ArrayListValue
    extends ListValue {
        private final AnyValue[] values;

        ArrayListValue(AnyValue[] values2) {
            assert (values2 != null);
            assert (!ArrayHelpers.containsNull(values2));
            this.values = values2;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return SequenceValue.IterationPreference.RANDOM_ACCESS;
        }

        @Override
        public int size() {
            return this.values.length;
        }

        @Override
        public AnyValue value(int offset) {
            return this.values[offset];
        }

        @Override
        public AnyValue[] asArray() {
            return this.values;
        }

        @Override
        public int computeHash() {
            return Arrays.hashCode(this.values);
        }
    }

    static final class ArrayValueListValue
    extends ListValue {
        private final ArrayValue array;

        ArrayValueListValue(ArrayValue array) {
            this.array = array;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return SequenceValue.IterationPreference.RANDOM_ACCESS;
        }

        @Override
        public boolean storable() {
            return true;
        }

        @Override
        public ArrayValue toStorableArray() {
            return this.array;
        }

        @Override
        public int size() {
            return this.array.length();
        }

        @Override
        public AnyValue value(int offset) {
            return this.array.value(offset);
        }

        @Override
        public int computeHash() {
            return this.array.hashCode();
        }
    }
}

