/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import java.io.Closeable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.ToIntFunction;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.Loaders;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.kernel.impl.transaction.state.TokenCreator;
import org.neo4j.unsafe.batchinsert.internal.DirectRecordAccess;

public abstract class BatchingTokenRepository<RECORD extends TokenRecord>
implements ToIntFunction<Object>,
Closeable {
    private final Map<String, Integer> tokens = new HashMap<String, Integer>();
    private final TokenStore<RECORD> store;
    private final RecordAccess.Loader<RECORD, Void> loader;
    private int highId;
    private int highestCreatedId;

    BatchingTokenRepository(TokenStore<RECORD> store, RecordAccess.Loader<RECORD, Void> loader) {
        this.store = store;
        this.loader = loader;
        this.highId = (int)store.getHighId();
        this.highestCreatedId = this.highId - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOrCreateId(String name) {
        assert (name != null);
        Integer id2 = this.tokens.get(name);
        if (id2 == null) {
            Map<String, Integer> map2 = this.tokens;
            synchronized (map2) {
                id2 = this.tokens.computeIfAbsent(name, k -> this.highId++);
            }
        }
        return id2;
    }

    public int getOrCreateId(Object key) {
        if (key instanceof String) {
            return this.getOrCreateId((String)key);
        }
        if (key instanceof Integer) {
            return (Integer)key;
        }
        throw new IllegalArgumentException("Expected either a String or Integer for property key, but was '" + key + "', " + key.getClass());
    }

    @Override
    public int applyAsInt(Object key) {
        return this.getOrCreateId(key);
    }

    public long[] getOrCreateIds(String[] names) {
        return this.getOrCreateIds(names, names.length);
    }

    public long[] getOrCreateIds(String[] names, int length2) {
        int from2;
        long[] result2 = new long[length2];
        int to2 = 0;
        for (from2 = 0; from2 < length2; ++from2) {
            int id2 = this.getOrCreateId(names[from2]);
            if (this.contains(result2, id2, to2)) continue;
            result2[to2++] = id2;
        }
        if (to2 < from2) {
            result2 = Arrays.copyOf(result2, to2);
        }
        Arrays.sort(result2);
        return result2;
    }

    private boolean contains(long[] array, long id2, int arrayLength) {
        for (int i = 0; i < arrayLength; ++i) {
            if (array[i] != id2) continue;
            return true;
        }
        return false;
    }

    public int getHighId() {
        return this.highId;
    }

    @Override
    public void close() {
        this.flush();
    }

    public void flush() {
        DirectRecordAccess<RECORD, Void> recordAccess = new DirectRecordAccess<RECORD, Void>(this.store, this.loader);
        TokenCreator<RECORD> creator = new TokenCreator<RECORD>(this.store);
        int highest = this.highestCreatedId;
        for (Map.Entry<Integer, String> tokenToCreate : this.sortCreatedTokensById()) {
            if (tokenToCreate.getKey() <= this.highestCreatedId) continue;
            creator.createToken(tokenToCreate.getValue(), tokenToCreate.getKey().intValue(), recordAccess);
            highest = Math.max(highest, tokenToCreate.getKey());
        }
        int highestId = Math.max(Math.toIntExact(this.store.getHighestPossibleIdInUse()), highest);
        recordAccess.close();
        this.store.setHighestPossibleIdInUse(highestId);
        this.highestCreatedId = highestId;
    }

    private Iterable<Map.Entry<Integer, String>> sortCreatedTokensById() {
        TreeMap<Integer, String> sorted2 = new TreeMap<Integer, String>();
        for (Map.Entry<String, Integer> entry : this.tokens.entrySet()) {
            sorted2.put(entry.getValue(), entry.getKey());
        }
        return sorted2.entrySet();
    }

    public static class BatchingRelationshipTypeTokenRepository
    extends BatchingTokenRepository<RelationshipTypeTokenRecord> {
        BatchingRelationshipTypeTokenRepository(TokenStore<RelationshipTypeTokenRecord> store) {
            super(store, Loaders.relationshipTypeTokenLoader(store));
        }
    }

    public static class BatchingLabelTokenRepository
    extends BatchingTokenRepository<LabelTokenRecord> {
        BatchingLabelTokenRepository(TokenStore<LabelTokenRecord> store) {
            super(store, Loaders.labelTokenLoader(store));
        }
    }

    public static class BatchingPropertyKeyTokenRepository
    extends BatchingTokenRepository<PropertyKeyTokenRecord> {
        BatchingPropertyKeyTokenRepository(TokenStore<PropertyKeyTokenRecord> store) {
            super(store, Loaders.propertyKeyTokenLoader(store));
        }
    }
}

