/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.Arrays;
import java.util.Collections;
import org.neo4j.kernel.impl.store.InlineNodeLabels;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.unsafe.impl.batchimport.BatchingIdGetter;
import org.neo4j.unsafe.impl.batchimport.DataImporter;
import org.neo4j.unsafe.impl.batchimport.EntityImporter;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.store.BatchingNeoStores;
import org.neo4j.unsafe.impl.batchimport.store.BatchingTokenRepository;
import org.neo4j.values.storable.Values;

public class NodeImporter
extends EntityImporter {
    private final BatchingTokenRepository.BatchingLabelTokenRepository labelTokenRepository;
    private final NodeStore nodeStore;
    private final NodeRecord nodeRecord;
    private final IdMapper idMapper;
    private final BatchingIdGetter nodeIds;
    private final PropertyStore idPropertyStore;
    private final PropertyRecord idPropertyRecord;
    private final PropertyBlock idPropertyBlock = new PropertyBlock();
    private String[] labels = new String[10];
    private int labelsCursor;
    private long nodeCount;
    private long highestId = -1L;
    private boolean hasLabelField;

    public NodeImporter(BatchingNeoStores stores, IdMapper idMapper, DataImporter.Monitor monitor) {
        super(stores, monitor);
        this.labelTokenRepository = stores.getLabelRepository();
        this.idMapper = idMapper;
        this.nodeStore = stores.getNodeStore();
        this.nodeRecord = (NodeRecord)this.nodeStore.newRecord();
        this.nodeIds = new BatchingIdGetter(this.nodeStore);
        this.idPropertyStore = stores.getTemporaryPropertyStore();
        this.idPropertyRecord = this.idPropertyStore.newRecord();
        this.nodeRecord.setInUse(true);
    }

    @Override
    public boolean id(long id2) {
        this.nodeRecord.setId(id2);
        this.highestId = Long.max(this.highestId, id2);
        return true;
    }

    @Override
    public boolean id(Object id2, Group group) {
        long nodeId = this.nodeIds.next();
        this.nodeRecord.setId(nodeId);
        this.idMapper.put(id2, nodeId, group);
        if (id2 != null) {
            this.idPropertyStore.encodeValue(this.idPropertyBlock, 0, Values.of(id2));
            this.idPropertyRecord.addPropertyBlock(this.idPropertyBlock);
            this.idPropertyRecord.setId(nodeId);
            this.idPropertyRecord.setInUse(true);
            this.idPropertyStore.updateRecord(this.idPropertyRecord);
            this.idPropertyRecord.clear();
        }
        return true;
    }

    @Override
    public boolean labels(String[] labels2) {
        assert (!this.hasLabelField);
        if (this.labelsCursor + labels2.length > this.labels.length) {
            this.labels = Arrays.copyOf(this.labels, this.labels.length * 2);
        }
        System.arraycopy(labels2, 0, this.labels, this.labelsCursor, labels2.length);
        this.labelsCursor += labels2.length;
        return true;
    }

    @Override
    public boolean labelField(long labelField) {
        this.hasLabelField = true;
        this.nodeRecord.setLabelField(labelField, Collections.emptyList());
        return true;
    }

    @Override
    public void endOfEntity() {
        if (this.nodeRecord.getId() == Record.NULL_REFERENCE.longValue()) {
            this.nodeRecord.setId(this.nodeIds.next());
        }
        if (!this.hasLabelField) {
            long[] labelIds = this.labelTokenRepository.getOrCreateIds(this.labels, this.labelsCursor);
            InlineNodeLabels.putSorted(this.nodeRecord, labelIds, null, this.nodeStore.getDynamicLabelStore());
        }
        this.labelsCursor = 0;
        this.nodeRecord.setNextProp(this.createAndWritePropertyChain());
        this.nodeRecord.setInUse(true);
        this.nodeStore.updateRecord(this.nodeRecord);
        ++this.nodeCount;
        this.nodeRecord.clear();
        this.nodeRecord.setId(Record.NULL_REFERENCE.longValue());
        this.hasLabelField = false;
        super.endOfEntity();
    }

    @Override
    protected PrimitiveRecord primitiveRecord() {
        return this.nodeRecord;
    }

    @Override
    public void close() {
        super.close();
        this.monitor.nodesImported(this.nodeCount);
        this.nodeStore.setHighestPossibleIdInUse(this.highestId);
    }
}

