/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal;

import org.neo4j.graphdb.event.ErrorState;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.core.DatabasePanicEventGenerator;
import org.neo4j.logging.Log;

public class DatabaseHealth {
    private static final String panicMessage = "The database has encountered a critical error, and needs to be restarted. Please see database logs for more details.";
    private static final Class<?>[] CRITICAL_EXCEPTIONS = new Class[]{OutOfMemoryError.class};
    private volatile boolean healthy = true;
    private final DatabasePanicEventGenerator dbpe;
    private final Log log;
    private Throwable causeOfPanic;

    public DatabaseHealth(DatabasePanicEventGenerator dbpe, Log log) {
        this.dbpe = dbpe;
        this.log = log;
    }

    public <EXCEPTION extends Throwable> void assertHealthy(Class<EXCEPTION> panicDisguise) throws EXCEPTION {
        if (!this.healthy) {
            Throwable exception;
            try {
                try {
                    exception = (Throwable)panicDisguise.getConstructor(String.class, Throwable.class).newInstance(panicMessage, this.causeOfPanic);
                }
                catch (NoSuchMethodException e) {
                    exception = (Throwable)panicDisguise.getConstructor(String.class).newInstance(panicMessage);
                    try {
                        exception.initCause(this.causeOfPanic);
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
            }
            catch (Exception e) {
                throw new Error("The database has encountered a critical error, and needs to be restarted. Please see database logs for more details.. An exception of type " + panicDisguise.getName() + " was requested to be thrown but that proved impossible", e);
            }
            throw exception;
        }
    }

    public void panic(Throwable cause) {
        if (!this.healthy) {
            return;
        }
        if (cause == null) {
            throw new IllegalArgumentException("Must provide a cause for the database panic");
        }
        this.causeOfPanic = cause;
        this.healthy = false;
        this.log.error("Database panic: The database has encountered a critical error, and needs to be restarted. Please see database logs for more details.", cause);
        this.dbpe.generateEvent(ErrorState.TX_MANAGER_NOT_OK, this.causeOfPanic);
    }

    public boolean isHealthy() {
        return this.healthy;
    }

    public boolean healed() {
        if (this.hasCriticalFailure()) {
            this.log.error("Database encountered a critical error and can't be healed. Restart required.");
            return false;
        }
        this.healthy = true;
        this.causeOfPanic = null;
        this.log.info("Database health set to OK");
        return true;
    }

    private boolean hasCriticalFailure() {
        return !this.isHealthy() && Exceptions.contains(this.causeOfPanic, CRITICAL_EXCEPTIONS);
    }

    public Throwable cause() {
        return this.causeOfPanic;
    }
}

