/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.impl.util.NumberAwareStringComparator;
import org.neo4j.kernel.impl.util.OptionalHostnamePort;
import org.neo4j.kernel.impl.util.Validators;

public class Converters {
    public static final Comparator<File> BY_FILE_NAME = Comparator.comparing(File::getName);
    public static final Comparator<File> BY_FILE_NAME_WITH_CLEVER_NUMBERS = (o1, o2) -> NumberAwareStringComparator.INSTANCE.compare(o1.getAbsolutePath(), o2.getAbsolutePath());

    private Converters() {
    }

    public static <T> Function<String, T> mandatory() {
        return key -> {
            throw new IllegalArgumentException("Missing argument '" + key + "'");
        };
    }

    public static <T> Function<String, T> optional() {
        return from2 -> null;
    }

    public static <T> Function<String, T> withDefault(T defaultValue) {
        return from2 -> defaultValue;
    }

    public static Function<String, File> toFile() {
        return File::new;
    }

    public static Function<String, Path> toPath() {
        return x$0 -> Paths.get(x$0, new String[0]);
    }

    public static Function<String, String> identity() {
        return s2 -> s2;
    }

    public static Function<String, File[]> regexFiles(boolean cleverNumberRegexSort) {
        return name -> {
            Comparator<File> sorting = cleverNumberRegexSort ? BY_FILE_NAME_WITH_CLEVER_NUMBERS : BY_FILE_NAME;
            List<File> files2 = Validators.matchingFiles(new File(name.trim()));
            files2.sort(sorting);
            return files2.toArray(new File[files2.size()]);
        };
    }

    public static Function<String, File[]> toFiles(String delimiter, Function<String, File[]> eachFileConverter) {
        return from2 -> {
            if (from2 == null) {
                return new File[0];
            }
            String[] names = from2.split(delimiter);
            ArrayList<Object> files2 = new ArrayList<Object>();
            for (String name : names) {
                files2.addAll(Arrays.asList((Object[])eachFileConverter.apply(name)));
            }
            return files2.toArray(new File[files2.size()]);
        };
    }

    public static Function<String, Integer> toInt() {
        return Integer::new;
    }

    public static OptionalHostnamePort toOptionalHostnamePortFromRawAddress(String rawAddress) {
        HostnamePort hostnamePort = new HostnamePort(rawAddress);
        Optional<String> processedHost = Optional.ofNullable(hostnamePort.getHost()).map(str2 -> str2.replaceAll("\\[", "")).map(str2 -> str2.replaceAll("]", ""));
        return new OptionalHostnamePort(processedHost, Converters.optionalFromZeroable(hostnamePort.getPorts()[0]), Converters.optionalFromZeroable(hostnamePort.getPorts()[1]));
    }

    private static Optional<Integer> optionalFromZeroable(int port) {
        return port == 0 ? Optional.empty() : Optional.of(port);
    }
}

