/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.participant;

import java.io.File;
import java.io.IOException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.store.format.CapabilityType;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.storemigration.participant.AbstractStoreMigrationParticipant;
import org.neo4j.kernel.impl.util.monitoring.ProgressReporter;

public class SchemaIndexMigrator
extends AbstractStoreMigrationParticipant {
    private final FileSystemAbstraction fileSystem;
    private boolean deleteObsoleteIndexes;
    private File schemaIndexDirectory;
    private final IndexProvider indexProvider;

    public SchemaIndexMigrator(FileSystemAbstraction fileSystem, IndexProvider indexProvider) {
        super("Indexes");
        this.fileSystem = fileSystem;
        this.indexProvider = indexProvider;
    }

    @Override
    public void migrate(DatabaseLayout directoryLayout, DatabaseLayout migrationLayout, ProgressReporter progressReporter, String versionToMigrateFrom, String versionToMigrateTo) {
        RecordFormats to2;
        RecordFormats from2 = RecordFormatSelector.selectForVersion(versionToMigrateFrom);
        if (!from2.hasCompatibleCapabilities(to2 = RecordFormatSelector.selectForVersion(versionToMigrateTo), CapabilityType.INDEX)) {
            this.schemaIndexDirectory = this.indexProvider.directoryStructure().rootDirectory();
            if (this.schemaIndexDirectory != null) {
                this.deleteObsoleteIndexes = true;
            }
        }
    }

    @Override
    public void moveMigratedFiles(DatabaseLayout migrationLayout, DatabaseLayout directoryLayout, String versionToUpgradeFrom, String versionToMigrateTo) throws IOException {
        if (this.deleteObsoleteIndexes) {
            this.deleteIndexes(this.schemaIndexDirectory);
        }
    }

    private void deleteIndexes(File indexRootDirectory) throws IOException {
        this.fileSystem.deleteRecursively(indexRootDirectory);
    }
}

