/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.file.OpenOption;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Collection;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.GeometryType;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.ShortArray;
import org.neo4j.kernel.impl.store.TemporalType;
import org.neo4j.kernel.impl.store.format.Capability;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.UnsupportedFormatCapabilityException;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.util.Bits;
import org.neo4j.logging.LogProvider;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class DynamicArrayStore
extends AbstractDynamicStore {
    public static final int NUMBER_HEADER_SIZE = 3;
    public static final int STRING_HEADER_SIZE = 5;
    public static final int GEOMETRY_HEADER_SIZE = 6;
    public static final int TEMPORAL_HEADER_SIZE = 2;
    public static final String TYPE_DESCRIPTOR = "ArrayPropertyStore";
    private final boolean allowStorePointsAndTemporal;

    public DynamicArrayStore(File file, File idFile, Config configuration, IdType idType, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, LogProvider logProvider, int dataSizeFromConfiguration, RecordFormats recordFormats, OpenOption ... openOptions) {
        super(file, idFile, configuration, idType, idGeneratorFactory, pageCache, logProvider, TYPE_DESCRIPTOR, dataSizeFromConfiguration, recordFormats.dynamic(), recordFormats.storeVersion(), openOptions);
        this.allowStorePointsAndTemporal = recordFormats.hasCapability(Capability.POINT_PROPERTIES) && recordFormats.hasCapability(Capability.TEMPORAL_PROPERTIES);
    }

    @Override
    public <FAILURE extends Exception> void accept(RecordStore.Processor<FAILURE> processor, DynamicRecord record) throws FAILURE {
        processor.processArray(this, record);
    }

    public static byte[] encodeFromNumbers(Object array, int offsetBytes) {
        ShortArray type = ShortArray.typeOf(array);
        if (type == null) {
            throw new IllegalArgumentException(array + " not a valid array type.");
        }
        if (type == ShortArray.DOUBLE || type == ShortArray.FLOAT) {
            return DynamicArrayStore.createUncompactedArray(type, array, offsetBytes);
        }
        return DynamicArrayStore.createBitCompactedArray(type, array, offsetBytes);
    }

    private static byte[] createBitCompactedArray(ShortArray type, Object array, int offsetBytes) {
        Class<?> componentType = array.getClass().getComponentType();
        boolean isPrimitiveByteArray = componentType.equals(Byte.TYPE);
        boolean isByteArray = componentType.equals(Byte.class) || isPrimitiveByteArray;
        int arrayLength = Array.getLength(array);
        int requiredBits = isByteArray ? 8 : type.calculateRequiredBitsForArray(array, arrayLength);
        int totalBits = requiredBits * arrayLength;
        int bitsUsedInLastByte = totalBits % 8;
        int n = bitsUsedInLastByte = bitsUsedInLastByte == 0 ? 8 : bitsUsedInLastByte;
        if (isByteArray) {
            return DynamicArrayStore.createBitCompactedByteArray(type, isPrimitiveByteArray, array, bitsUsedInLastByte, requiredBits, offsetBytes);
        }
        int numberOfBytes = (totalBits - 1) / 8 + 1;
        Bits bits2 = Bits.bits(numberOfBytes += 3);
        bits2.put((byte)type.intValue());
        bits2.put((byte)bitsUsedInLastByte);
        bits2.put((byte)requiredBits);
        type.writeAll(array, arrayLength, requiredBits, bits2);
        return bits2.asBytes(offsetBytes);
    }

    private static byte[] createBitCompactedByteArray(ShortArray type, boolean isPrimitiveByteArray, Object array, int bitsUsedInLastByte, int requiredBits, int offsetBytes) {
        int arrayLength = Array.getLength(array);
        byte[] bytes2 = new byte[3 + arrayLength + offsetBytes];
        bytes2[offsetBytes + 0] = (byte)type.intValue();
        bytes2[offsetBytes + 1] = (byte)bitsUsedInLastByte;
        bytes2[offsetBytes + 2] = (byte)requiredBits;
        if (isPrimitiveByteArray) {
            System.arraycopy(array, 0, bytes2, 3 + offsetBytes, arrayLength);
        } else {
            Byte[] source = (Byte[])array;
            for (int i = 0; i < source.length; ++i) {
                bytes2[3 + offsetBytes + i] = source[i];
            }
        }
        return bytes2;
    }

    private static byte[] createUncompactedArray(ShortArray type, Object array, int offsetBytes) {
        int arrayLength = Array.getLength(array);
        int bytesPerElement = type.maxBits / 8;
        byte[] bytes2 = new byte[3 + bytesPerElement * arrayLength + offsetBytes];
        bytes2[offsetBytes + 0] = (byte)type.intValue();
        bytes2[offsetBytes + 1] = 8;
        bytes2[offsetBytes + 2] = (byte)type.maxBits;
        type.writeAll(array, bytes2, 3 + offsetBytes);
        return bytes2;
    }

    public static void allocateFromNumbers(Collection<DynamicRecord> target, Object array, DynamicRecordAllocator recordAllocator) {
        byte[] bytes2 = DynamicArrayStore.encodeFromNumbers(array, 0);
        DynamicArrayStore.allocateRecordsFromBytes(target, bytes2, recordAllocator);
    }

    private static void allocateFromCompositeType(Collection<DynamicRecord> target, byte[] bytes2, DynamicRecordAllocator recordAllocator, boolean allowsStorage, Capability storageCapability) {
        if (!allowsStorage) {
            throw new UnsupportedFormatCapabilityException(storageCapability);
        }
        DynamicArrayStore.allocateRecordsFromBytes(target, bytes2, recordAllocator);
    }

    private static void allocateFromString(Collection<DynamicRecord> target, String[] array, DynamicRecordAllocator recordAllocator) {
        byte[][] stringsAsBytes = new byte[array.length][];
        int totalBytesRequired = 5;
        for (int i = 0; i < array.length; ++i) {
            String string2 = array[i];
            byte[] bytes2 = PropertyStore.encodeString(string2);
            stringsAsBytes[i] = bytes2;
            totalBytesRequired += 4 + bytes2.length;
        }
        ByteBuffer buf = ByteBuffer.allocate(totalBytesRequired);
        buf.put(PropertyType.STRING.byteValue());
        buf.putInt(array.length);
        for (byte[] stringAsBytes : stringsAsBytes) {
            buf.putInt(stringAsBytes.length);
            buf.put(stringAsBytes);
        }
        DynamicArrayStore.allocateRecordsFromBytes(target, buf.array(), recordAllocator);
    }

    public void allocateRecords(Collection<DynamicRecord> target, Object array) {
        DynamicArrayStore.allocateRecords(target, array, this, this.allowStorePointsAndTemporal);
    }

    public static void allocateRecords(Collection<DynamicRecord> target, Object array, DynamicRecordAllocator recordAllocator, boolean allowStorePointsAndTemporal) {
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException(array + " not an array");
        }
        Class<?> type = array.getClass().getComponentType();
        if (type.equals(String.class)) {
            DynamicArrayStore.allocateFromString(target, (String[])array, recordAllocator);
        } else if (type.equals(PointValue.class)) {
            DynamicArrayStore.allocateFromCompositeType(target, GeometryType.encodePointArray((PointValue[])array), recordAllocator, allowStorePointsAndTemporal, Capability.POINT_PROPERTIES);
        } else if (type.equals(LocalDate.class)) {
            DynamicArrayStore.allocateFromCompositeType(target, TemporalType.encodeDateArray((LocalDate[])array), recordAllocator, allowStorePointsAndTemporal, Capability.TEMPORAL_PROPERTIES);
        } else if (type.equals(LocalTime.class)) {
            DynamicArrayStore.allocateFromCompositeType(target, TemporalType.encodeLocalTimeArray((LocalTime[])array), recordAllocator, allowStorePointsAndTemporal, Capability.TEMPORAL_PROPERTIES);
        } else if (type.equals(LocalDateTime.class)) {
            DynamicArrayStore.allocateFromCompositeType(target, TemporalType.encodeLocalDateTimeArray((LocalDateTime[])array), recordAllocator, allowStorePointsAndTemporal, Capability.TEMPORAL_PROPERTIES);
        } else if (type.equals(OffsetTime.class)) {
            DynamicArrayStore.allocateFromCompositeType(target, TemporalType.encodeTimeArray((OffsetTime[])array), recordAllocator, allowStorePointsAndTemporal, Capability.TEMPORAL_PROPERTIES);
        } else if (type.equals(ZonedDateTime.class)) {
            DynamicArrayStore.allocateFromCompositeType(target, TemporalType.encodeDateTimeArray((ZonedDateTime[])array), recordAllocator, allowStorePointsAndTemporal, Capability.TEMPORAL_PROPERTIES);
        } else if (type.equals(DurationValue.class)) {
            DynamicArrayStore.allocateFromCompositeType(target, TemporalType.encodeDurationArray((DurationValue[])array), recordAllocator, allowStorePointsAndTemporal, Capability.TEMPORAL_PROPERTIES);
        } else {
            DynamicArrayStore.allocateFromNumbers(target, array, recordAllocator);
        }
    }

    public static Value getRightArray(Pair<byte[], byte[]> data) {
        byte[] header = (byte[])data.first();
        byte[] bArray = (byte[])data.other();
        byte typeId = header[0];
        if (typeId == PropertyType.STRING.intValue()) {
            ByteBuffer headerBuffer = ByteBuffer.wrap(header, 1, header.length - 1);
            int arrayLength = headerBuffer.getInt();
            String[] result2 = new String[arrayLength];
            ByteBuffer dataBuffer = ByteBuffer.wrap(bArray);
            for (int i = 0; i < arrayLength; ++i) {
                int byteLength = dataBuffer.getInt();
                byte[] stringByteArray = new byte[byteLength];
                dataBuffer.get(stringByteArray);
                result2[i] = PropertyStore.decodeString(stringByteArray);
            }
            return Values.stringArray(result2);
        }
        if (typeId == PropertyType.GEOMETRY.intValue()) {
            GeometryType.GeometryHeader geometryHeader = GeometryType.GeometryHeader.fromArrayHeaderBytes(header);
            return GeometryType.decodeGeometryArray(geometryHeader, bArray);
        }
        if (typeId == PropertyType.TEMPORAL.intValue()) {
            TemporalType.TemporalHeader temporalHeader = TemporalType.TemporalHeader.fromArrayHeaderBytes(header);
            return TemporalType.decodeTemporalArray(temporalHeader, bArray);
        }
        ShortArray type = ShortArray.typeOf(typeId);
        byte bitsUsedInLastByte = header[1];
        byte requiredBits = header[2];
        if (requiredBits == 0) {
            return type.createEmptyArray();
        }
        if (type == ShortArray.BYTE && requiredBits == 8) {
            return Values.byteArray(bArray);
        }
        Bits bits2 = Bits.bitsFromBytes(bArray);
        int length2 = (bArray.length * 8 - (8 - bitsUsedInLastByte)) / requiredBits;
        return type.createArray(length2, bits2, requiredBits);
    }

    public Object getArrayFor(Iterable<DynamicRecord> records) {
        return DynamicArrayStore.getRightArray(this.readFullByteArray(records, PropertyType.ARRAY)).asObject();
    }
}

