/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import java.util.Arrays;
import java.util.LinkedList;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.kernel.impl.util.Listener;

public class PropertyTraverser {
    public long findPropertyRecordContaining(PrimitiveRecord primitive, int propertyKey, RecordAccess<PropertyRecord, PrimitiveRecord> propertyRecords, boolean strict) {
        long propertyRecordId = primitive.getNextProp();
        while (!Record.NO_NEXT_PROPERTY.is(propertyRecordId)) {
            PropertyRecord propertyRecord = propertyRecords.getOrLoad(propertyRecordId, primitive).forReadingLinkage();
            if (propertyRecord.getPropertyBlock(propertyKey) != null) {
                return propertyRecordId;
            }
            propertyRecordId = propertyRecord.getNextProp();
        }
        if (strict) {
            throw new IllegalStateException("No property record in property chain for " + primitive + " contained property with key " + propertyKey);
        }
        return Record.NO_NEXT_PROPERTY.intValue();
    }

    public void getPropertyChain(long nextProp, RecordAccess<PropertyRecord, PrimitiveRecord> propertyRecords, Listener<PropertyBlock> collector) {
        while (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord propRecord = propertyRecords.getOrLoad(nextProp, null).forReadingData();
            for (PropertyBlock propBlock : propRecord) {
                collector.receive(propBlock);
            }
            nextProp = propRecord.getNextProp();
        }
    }

    public boolean assertPropertyChain(PrimitiveRecord primitive, RecordAccess<PropertyRecord, PrimitiveRecord> propertyRecords) {
        LinkedList<PropertyRecord> toCheck = new LinkedList<PropertyRecord>();
        long nextIdToFetch = primitive.getNextProp();
        while (nextIdToFetch != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord propRecord = propertyRecords.getOrLoad(nextIdToFetch, primitive).forReadingLinkage();
            toCheck.add(propRecord);
            assert (propRecord.inUse()) : primitive + "->" + Arrays.toString(toCheck.toArray());
            assert (propRecord.size() <= PropertyType.getPayloadSize()) : propRecord + " size " + propRecord.size();
            nextIdToFetch = propRecord.getNextProp();
        }
        if (toCheck.isEmpty()) {
            assert (primitive.getNextProp() == (long)Record.NO_NEXT_PROPERTY.intValue()) : primitive;
            return true;
        }
        PropertyRecord first = (PropertyRecord)toCheck.get(0);
        PropertyRecord last2 = (PropertyRecord)toCheck.get(toCheck.size() - 1);
        assert (first.getPrevProp() == (long)Record.NO_PREVIOUS_PROPERTY.intValue()) : primitive + "->" + Arrays.toString(toCheck.toArray());
        assert (last2.getNextProp() == (long)Record.NO_NEXT_PROPERTY.intValue()) : primitive + "->" + Arrays.toString(toCheck.toArray());
        PropertyRecord previous = first;
        for (int i = 1; i < toCheck.size(); ++i) {
            PropertyRecord current = (PropertyRecord)toCheck.get(i);
            assert (current.getPrevProp() == previous.getId()) : primitive + "->" + Arrays.toString(toCheck.toArray());
            assert (previous.getNextProp() == current.getId()) : primitive + "->" + Arrays.toString(toCheck.toArray());
            previous = current;
        }
        return true;
    }
}

