/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

public enum RelationshipReferenceEncoding {
    NONE(0L),
    FILTER(1L),
    FILTER_TX_STATE(2L),
    GROUP(3L),
    NO_OUTGOING_OF_TYPE(4L),
    NO_INCOMING_OF_TYPE(5L),
    NO_LOOP_OF_TYPE(6L);

    private static final RelationshipReferenceEncoding[] ENCODINGS;
    final long id;
    final long bits;

    private RelationshipReferenceEncoding(long id2) {
        this.id = id2;
        this.bits = id2 << 60;
    }

    public static RelationshipReferenceEncoding parseEncoding(long reference) {
        if (reference == -1L) {
            return NONE;
        }
        return ENCODINGS[RelationshipReferenceEncoding.encodingId(reference)];
    }

    private static int encodingId(long reference) {
        return (int)((reference & 0x7000000000000000L) >> 60);
    }

    public static long encodeGroup(long groupId) {
        return groupId | RelationshipReferenceEncoding.GROUP.bits | Long.MIN_VALUE;
    }

    public static long encodeForFiltering(long relationshipId) {
        return relationshipId | RelationshipReferenceEncoding.FILTER.bits | Long.MIN_VALUE;
    }

    public static long encodeForTxStateFiltering(long relationshipId) {
        return relationshipId | RelationshipReferenceEncoding.FILTER_TX_STATE.bits | Long.MIN_VALUE;
    }

    public static long encodeNoOutgoingRels(int type) {
        return (long)type | RelationshipReferenceEncoding.NO_OUTGOING_OF_TYPE.bits | Long.MIN_VALUE;
    }

    public static long encodeNoIncomingRels(int type) {
        return (long)type | RelationshipReferenceEncoding.NO_INCOMING_OF_TYPE.bits | Long.MIN_VALUE;
    }

    public static long encodeNoLoopRels(int type) {
        return (long)type | RelationshipReferenceEncoding.NO_LOOP_OF_TYPE.bits | Long.MIN_VALUE;
    }

    static {
        ENCODINGS = RelationshipReferenceEncoding.values();
    }
}

