/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.impl.iterator.ImmutableEmptyLongIterator;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.kernel.impl.newapi.DefaultCursors;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipCursor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.newapi.References;
import org.neo4j.kernel.impl.newapi.RelationshipReferenceEncoding;
import org.neo4j.storageengine.api.RelationshipDirection;
import org.neo4j.storageengine.api.RelationshipVisitor;
import org.neo4j.storageengine.api.StorageRelationshipTraversalCursor;
import org.neo4j.storageengine.api.txstate.NodeState;

class DefaultRelationshipTraversalCursor
extends DefaultRelationshipCursor<StorageRelationshipTraversalCursor>
implements RelationshipTraversalCursor {
    private FilterState filterState;
    private boolean filterStore;
    private int filterType = -1;
    private LongIterator addedRelationships;

    DefaultRelationshipTraversalCursor(DefaultCursors pool, StorageRelationshipTraversalCursor storeCursor) {
        super(pool, storeCursor);
    }

    void init(long nodeReference, long reference, Read read) {
        RelationshipReferenceEncoding encoding = RelationshipReferenceEncoding.parseEncoding(reference);
        switch (encoding) {
            case NONE: 
            case GROUP: {
                ((StorageRelationshipTraversalCursor)this.storeCursor).init(nodeReference, reference);
                this.initFiltering(FilterState.NONE, false);
                break;
            }
            case FILTER_TX_STATE: {
                ((StorageRelationshipTraversalCursor)this.storeCursor).init(nodeReference, References.clearEncoding(reference));
                this.initFiltering(FilterState.NOT_INITIALIZED, false);
                break;
            }
            case FILTER: {
                ((StorageRelationshipTraversalCursor)this.storeCursor).init(nodeReference, References.clearEncoding(reference));
                this.initFiltering(FilterState.NOT_INITIALIZED, true);
                break;
            }
            case NO_OUTGOING_OF_TYPE: {
                ((StorageRelationshipTraversalCursor)this.storeCursor).init(nodeReference, -1L);
                this.initFiltering(FilterState.fromRelationshipDirection(RelationshipDirection.OUTGOING), false);
                this.filterType = (int)References.clearEncoding(reference);
                break;
            }
            case NO_INCOMING_OF_TYPE: {
                ((StorageRelationshipTraversalCursor)this.storeCursor).init(nodeReference, -1L);
                this.initFiltering(FilterState.fromRelationshipDirection(RelationshipDirection.INCOMING), false);
                this.filterType = (int)References.clearEncoding(reference);
                break;
            }
            case NO_LOOP_OF_TYPE: {
                ((StorageRelationshipTraversalCursor)this.storeCursor).init(nodeReference, -1L);
                this.initFiltering(FilterState.fromRelationshipDirection(RelationshipDirection.LOOP), false);
                this.filterType = (int)References.clearEncoding(reference);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown encoding " + (Object)((Object)encoding));
            }
        }
        this.init(read);
        this.addedRelationships = ImmutableEmptyLongIterator.INSTANCE;
    }

    private void initFiltering(FilterState filterState, boolean filterStore) {
        this.filterState = filterState;
        this.filterStore = filterStore;
    }

    public RelationshipTraversalCursor.Position suspend() {
        throw new UnsupportedOperationException("not implemented");
    }

    public void resume(RelationshipTraversalCursor.Position position2) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void neighbour(NodeCursor cursor) {
        this.read.singleNode(this.neighbourNodeReference(), cursor);
    }

    public long neighbourNodeReference() {
        return ((StorageRelationshipTraversalCursor)this.storeCursor).neighbourNodeReference();
    }

    public long originNodeReference() {
        return ((StorageRelationshipTraversalCursor)this.storeCursor).originNodeReference();
    }

    public boolean next() {
        boolean hasChanges;
        if (this.filterState == FilterState.NOT_INITIALIZED) {
            hasChanges = this.hasChanges();
            if (this.filterState == FilterState.NOT_INITIALIZED && this.filterStore) {
                ((StorageRelationshipTraversalCursor)this.storeCursor).next();
                this.setupFilterState();
            }
            if (!(this.filterState == FilterState.NOT_INITIALIZED || hasChanges && this.read.txState().relationshipIsDeletedInThisTx(this.relationshipReference()))) {
                return true;
            }
        } else {
            hasChanges = this.hasChanges();
        }
        if (hasChanges && this.addedRelationships.hasNext()) {
            this.read.txState().relationshipVisit(this.addedRelationships.next(), (RelationshipVisitor)this.storeCursor);
            return true;
        }
        while (((StorageRelationshipTraversalCursor)this.storeCursor).next()) {
            boolean skip = this.filterStore && !this.correctTypeAndDirection() || hasChanges && this.read.txState().relationshipIsDeletedInThisTx(((StorageRelationshipTraversalCursor)this.storeCursor).entityReference());
            if (skip) continue;
            return true;
        }
        return false;
    }

    private void setupFilterState() {
        long target;
        this.filterType = ((StorageRelationshipTraversalCursor)this.storeCursor).type();
        long source = this.sourceNodeReference();
        if (source == (target = this.targetNodeReference())) {
            this.filterState = FilterState.LOOP;
        } else if (source == ((StorageRelationshipTraversalCursor)this.storeCursor).originNodeReference()) {
            this.filterState = FilterState.OUTGOING;
        } else if (target == ((StorageRelationshipTraversalCursor)this.storeCursor).originNodeReference()) {
            this.filterState = FilterState.INCOMING;
        }
    }

    private boolean correctTypeAndDirection() {
        return (this.filterType == -1 || this.filterType == ((StorageRelationshipTraversalCursor)this.storeCursor).type()) && this.filterState.check(this.sourceNodeReference(), this.targetNodeReference(), ((StorageRelationshipTraversalCursor)this.storeCursor).originNodeReference());
    }

    public void close() {
        if (!this.isClosed()) {
            this.read = null;
            this.filterState = FilterState.NONE;
            this.filterType = -1;
            this.filterStore = false;
            ((StorageRelationshipTraversalCursor)this.storeCursor).close();
            this.pool.accept(this);
        }
    }

    @Override
    protected void collectAddedTxStateSnapshot() {
        if (this.filterState == FilterState.NOT_INITIALIZED) {
            ((StorageRelationshipTraversalCursor)this.storeCursor).next();
            this.setupFilterState();
        }
        NodeState nodeState = this.read.txState().getNodeState(((StorageRelationshipTraversalCursor)this.storeCursor).originNodeReference());
        this.addedRelationships = this.hasTxStateFilter() ? nodeState.getAddedRelationships(this.filterState.direction, this.filterType) : nodeState.getAddedRelationships();
    }

    private boolean hasTxStateFilter() {
        return this.filterState != FilterState.NONE;
    }

    public boolean isClosed() {
        return this.read == null;
    }

    public void release() {
        ((StorageRelationshipTraversalCursor)this.storeCursor).close();
    }

    public String toString() {
        if (this.isClosed()) {
            return "RelationshipTraversalCursor[closed state]";
        }
        String mode = "mode=";
        mode = this.filterStore ? mode + "filterStore" : mode + "regular";
        return "RelationshipTraversalCursor[id=" + ((StorageRelationshipTraversalCursor)this.storeCursor).entityReference() + ", " + mode + ", " + ((StorageRelationshipTraversalCursor)this.storeCursor).toString() + "]";
    }

    private static enum FilterState {
        NOT_INITIALIZED(RelationshipDirection.ERROR){

            @Override
            boolean check(long source, long target, long origin) {
                throw new IllegalStateException("Cannot call check on uninitialized filter");
            }
        }
        ,
        INCOMING(RelationshipDirection.INCOMING){

            @Override
            boolean check(long source, long target, long origin) {
                return origin == target && source != target;
            }
        }
        ,
        OUTGOING(RelationshipDirection.OUTGOING){

            @Override
            boolean check(long source, long target, long origin) {
                return origin == source && source != target;
            }
        }
        ,
        LOOP(RelationshipDirection.LOOP){

            @Override
            boolean check(long source, long target, long origin) {
                return source == target;
            }
        }
        ,
        NONE(RelationshipDirection.ERROR){

            @Override
            boolean check(long source, long target, long origin) {
                return true;
            }
        };

        private final RelationshipDirection direction;

        abstract boolean check(long var1, long var3, long var5);

        private FilterState(RelationshipDirection direction) {
            this.direction = direction;
        }

        private static FilterState fromRelationshipDirection(RelationshipDirection direction) {
            switch (direction) {
                case OUTGOING: {
                    return OUTGOING;
                }
                case INCOMING: {
                    return INCOMING;
                }
                case LOOP: {
                    return LOOP;
                }
                case ERROR: {
                    throw new IllegalArgumentException("There has been a RelationshipDirection.ERROR");
                }
            }
            throw new IllegalStateException(String.format("Still poking my eye, dear checkstyle... (cannot filter on direction '%s')", direction));
        }
    }
}

