/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.annotations.ReporterFactory;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.index.schema.ConsistencyCheckable;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexPopulator;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.util.concurrent.Work;
import org.neo4j.util.concurrent.WorkSync;
import org.neo4j.values.storable.Value;

class WorkSyncedNativeIndexPopulator<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
implements IndexPopulator,
ConsistencyCheckable {
    private final NativeIndexPopulator<KEY, VALUE> actual;
    private final WorkSync<IndexUpdateApply, IndexUpdateWork> workSync = new WorkSync((Object)new IndexUpdateApply());

    WorkSyncedNativeIndexPopulator(NativeIndexPopulator<KEY, VALUE> actual2) {
        this.actual = actual2;
    }

    NativeIndexPopulator<KEY, VALUE> getActual() {
        return this.actual;
    }

    @Override
    public void create() {
        this.actual.create();
    }

    @Override
    public void drop() {
        this.actual.drop();
    }

    @Override
    public void add(Collection<? extends IndexEntryUpdate<?>> updates) throws IndexEntryConflictException {
        try {
            this.workSync.apply((Work)new IndexUpdateWork(updates));
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw new UncheckedIOException((IOException)cause);
            }
            if (cause instanceof IndexEntryConflictException) {
                throw (IndexEntryConflictException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    @Override
    public void verifyDeferredConstraints(NodePropertyAccessor nodePropertyAccessor) throws IndexEntryConflictException {
        this.actual.verifyDeferredConstraints(nodePropertyAccessor);
    }

    @Override
    public IndexUpdater newPopulatingUpdater(NodePropertyAccessor accessor) {
        return this.actual.newPopulatingUpdater(accessor);
    }

    @Override
    public void close(boolean populationCompletedSuccessfully) {
        this.actual.close(populationCompletedSuccessfully);
    }

    @Override
    public void markAsFailed(String failure) {
        this.actual.markAsFailed(failure);
    }

    @Override
    public void includeSample(IndexEntryUpdate<?> update2) {
        this.actual.includeSample(update2);
    }

    @Override
    public IndexSample sampleResult() {
        return this.actual.sampleResult();
    }

    @Override
    public boolean consistencyCheck(ReporterFactory reporterFactory) {
        return this.actual.consistencyCheck(reporterFactory);
    }

    @Override
    public void scanCompleted(PhaseTracker phaseTracker) throws IndexEntryConflictException {
        this.actual.scanCompleted(phaseTracker);
    }

    @Override
    public Map<String, Value> indexConfig() {
        return this.actual.indexConfig();
    }

    private class IndexUpdateWork
    implements Work<IndexUpdateApply, IndexUpdateWork> {
        private final Collection<? extends IndexEntryUpdate<?>> updates;

        IndexUpdateWork(Collection<? extends IndexEntryUpdate<?>> updates) {
            this.updates = updates;
        }

        public IndexUpdateWork combine(IndexUpdateWork work) {
            ArrayList combined = new ArrayList(this.updates);
            combined.addAll(work.updates);
            return new IndexUpdateWork(combined);
        }

        public void apply(IndexUpdateApply indexUpdateApply) throws Exception {
            indexUpdateApply.process(this.updates);
        }
    }

    private class IndexUpdateApply {
        private IndexUpdateApply() {
        }

        void process(Collection<? extends IndexEntryUpdate<?>> indexEntryUpdates) throws Exception {
            WorkSyncedNativeIndexPopulator.this.actual.add(indexEntryUpdates);
        }
    }
}

