/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.neo4j.kernel.impl.index.schema.AbstractArrayType;
import org.neo4j.kernel.impl.index.schema.BooleanArrayType;
import org.neo4j.kernel.impl.index.schema.BooleanType;
import org.neo4j.kernel.impl.index.schema.DateArrayType;
import org.neo4j.kernel.impl.index.schema.DateType;
import org.neo4j.kernel.impl.index.schema.DurationArrayType;
import org.neo4j.kernel.impl.index.schema.DurationType;
import org.neo4j.kernel.impl.index.schema.GeometryArrayType;
import org.neo4j.kernel.impl.index.schema.GeometryType;
import org.neo4j.kernel.impl.index.schema.LocalDateTimeArrayType;
import org.neo4j.kernel.impl.index.schema.LocalDateTimeType;
import org.neo4j.kernel.impl.index.schema.LocalTimeArrayType;
import org.neo4j.kernel.impl.index.schema.LocalTimeType;
import org.neo4j.kernel.impl.index.schema.NumberArrayType;
import org.neo4j.kernel.impl.index.schema.NumberType;
import org.neo4j.kernel.impl.index.schema.TextArrayType;
import org.neo4j.kernel.impl.index.schema.TextType;
import org.neo4j.kernel.impl.index.schema.Type;
import org.neo4j.kernel.impl.index.schema.ZonedDateTimeArrayType;
import org.neo4j.kernel.impl.index.schema.ZonedDateTimeType;
import org.neo4j.kernel.impl.index.schema.ZonedTimeArrayType;
import org.neo4j.kernel.impl.index.schema.ZonedTimeType;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;

class Types {
    static final GeometryType GEOMETRY = new GeometryType(0);
    static final ZonedDateTimeType ZONED_DATE_TIME = new ZonedDateTimeType(1);
    static final LocalDateTimeType LOCAL_DATE_TIME = new LocalDateTimeType(2);
    static final DateType DATE = new DateType(3);
    static final ZonedTimeType ZONED_TIME = new ZonedTimeType(4);
    static final LocalTimeType LOCAL_TIME = new LocalTimeType(5);
    static final DurationType DURATION = new DurationType(6);
    static final TextType TEXT = new TextType(7);
    static final BooleanType BOOLEAN = new BooleanType(8);
    static final NumberType NUMBER = new NumberType(9);
    static final GeometryArrayType GEOMETRY_ARRAY = new GeometryArrayType(10);
    static final ZonedDateTimeArrayType ZONED_DATE_TIME_ARRAY = new ZonedDateTimeArrayType(11);
    static final LocalDateTimeArrayType LOCAL_DATE_TIME_ARRAY = new LocalDateTimeArrayType(12);
    static final DateArrayType DATE_ARRAY = new DateArrayType(13);
    static final ZonedTimeArrayType ZONED_TIME_ARRAY = new ZonedTimeArrayType(14);
    static final LocalTimeArrayType LOCAL_TIME_ARRAY = new LocalTimeArrayType(15);
    static final DurationArrayType DURATION_ARRAY = new DurationArrayType(16);
    static final TextArrayType TEXT_ARRAY = new TextArrayType(17);
    static final BooleanArrayType BOOLEAN_ARRAY = new BooleanArrayType(18);
    static final NumberArrayType NUMBER_ARRAY = new NumberArrayType(19);
    static final Type[] BY_ID = Types.instantiateTypes();
    static final Type[] BY_GROUP = new Type[ValueGroup.values().length];
    static final AbstractArrayType[] BY_ARRAY_TYPE = new AbstractArrayType[ValueWriter.ArrayType.values().length];
    static final Type LOWEST_BY_VALUE_GROUP = Collections.min(Arrays.asList(BY_ID), Type.COMPARATOR);
    static final Type HIGHEST_BY_VALUE_GROUP = Collections.max(Arrays.asList(BY_ID), Type.COMPARATOR);

    Types() {
    }

    private static AbstractArrayType<?> typeOf(ValueWriter.ArrayType arrayType) {
        switch (arrayType) {
            case BOOLEAN: {
                return BOOLEAN_ARRAY;
            }
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return NUMBER_ARRAY;
            }
            case STRING: 
            case CHAR: {
                return TEXT_ARRAY;
            }
            case LOCAL_DATE_TIME: {
                return LOCAL_DATE_TIME_ARRAY;
            }
            case DATE: {
                return DATE_ARRAY;
            }
            case DURATION: {
                return DURATION_ARRAY;
            }
            case POINT: {
                return GEOMETRY_ARRAY;
            }
            case LOCAL_TIME: {
                return LOCAL_TIME_ARRAY;
            }
            case ZONED_DATE_TIME: {
                return ZONED_DATE_TIME_ARRAY;
            }
            case ZONED_TIME: {
                return ZONED_TIME_ARRAY;
            }
        }
        throw new UnsupportedOperationException(arrayType.name());
    }

    private static Type[] instantiateTypes() {
        ArrayList<Type> types2 = new ArrayList<Type>();
        types2.add(GEOMETRY);
        types2.add(ZONED_DATE_TIME);
        types2.add(LOCAL_DATE_TIME);
        types2.add(DATE);
        types2.add(ZONED_TIME);
        types2.add(LOCAL_TIME);
        types2.add(DURATION);
        types2.add(TEXT);
        types2.add(BOOLEAN);
        types2.add(NUMBER);
        types2.add(GEOMETRY_ARRAY);
        types2.add(ZONED_DATE_TIME_ARRAY);
        types2.add(LOCAL_DATE_TIME_ARRAY);
        types2.add(DATE_ARRAY);
        types2.add(ZONED_TIME_ARRAY);
        types2.add(LOCAL_TIME_ARRAY);
        types2.add(DURATION_ARRAY);
        types2.add(TEXT_ARRAY);
        types2.add(BOOLEAN_ARRAY);
        types2.add(NUMBER_ARRAY);
        byte expectedTypeId = 0;
        for (Type type : types2) {
            if (type.typeId != expectedTypeId) {
                throw new IllegalStateException("The order in this list is not the intended one");
            }
            expectedTypeId = (byte)(expectedTypeId + 1);
        }
        return types2.toArray(new Type[0]);
    }

    static {
        Type[] objectArray = BY_ID;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Type type;
            Types.BY_GROUP[type.valueGroup.ordinal()] = type = objectArray[i];
        }
        for (ValueWriter.ArrayType arrayType : ValueWriter.ArrayType.values()) {
            Types.BY_ARRAY_TYPE[arrayType.ordinal()] = Types.typeOf(arrayType);
        }
    }
}

